/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageResolver;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.UniversalAvatarsService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeImpl;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityImpl;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.resolution.ResolutionImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.model.querydsl.IssueTypeDTO;
import com.atlassian.jira.model.querydsl.PriorityDTO;
import com.atlassian.jira.model.querydsl.ResolutionDTO;
import com.atlassian.jira.model.querydsl.StatusDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import java.net.URI;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueConstantFactory
implements IssueConstantFactory {
    private final TranslationManager translationManager;
    private final JiraAuthenticationContext authenticationContext;
    private final BaseUrl baseUrl;
    private final StatusCategoryManager statusCategoryManager;
    private final AvatarManager avatarManager;
    private final OfBizDelegator ofBizDelegator;

    public DefaultIssueConstantFactory(TranslationManager translationManager, JiraAuthenticationContext authenticationContext, BaseUrl baseUrl, StatusCategoryManager statusCategoryManager, AvatarManager avatarManager, OfBizDelegator ofBizDelegator) {
        this.translationManager = translationManager;
        this.authenticationContext = authenticationContext;
        this.baseUrl = baseUrl;
        this.statusCategoryManager = statusCategoryManager;
        this.avatarManager = avatarManager;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Priority createPriority(GenericValue priorityGv) {
        return new PriorityImpl((GenericValue)priorityGv.clone(), this.translationManager, this.authenticationContext, this.baseUrl);
    }

    @Override
    public Priority createPriority(PriorityDTO priorityDTO) {
        return this.createPriority(priorityDTO.toGenericValue(this.ofBizDelegator));
    }

    @Override
    public IssueType createIssueType(GenericValue issueTypeGv) {
        IssueTypeImpl issueType = new IssueTypeImpl(issueTypeGv, this.translationManager, this.authenticationContext, this.baseUrl, this.avatarManager);
        Avatar avatar = issueType.getAvatar();
        if (avatar != null) {
            UniversalAvatarsService universalAvatars = (UniversalAvatarsService)ComponentAccessor.getComponent(UniversalAvatarsService.class);
            AvatarImageResolver uriForIssueType = universalAvatars.getImages(Avatar.Type.ISSUETYPE);
            URI avatarURI = uriForIssueType.getAvatarRelativeUri(null, avatar, Avatar.Size.SMALL);
            String avatarURIString = avatarURI.toASCIIString();
            issueType.setIconUrl(avatarURIString);
        }
        return issueType;
    }

    @Override
    public IssueType createIssueType(IssueTypeDTO issueTypeDTO) {
        return this.createIssueType(issueTypeDTO.toGenericValue(this.ofBizDelegator));
    }

    @Override
    public Resolution createResolution(GenericValue resolutionGv) {
        return new ResolutionImpl(resolutionGv, this.translationManager, this.authenticationContext, this.baseUrl);
    }

    @Override
    public Resolution createResolution(ResolutionDTO resolutionDTO) {
        return this.createResolution(resolutionDTO.toGenericValue(this.ofBizDelegator));
    }

    @Override
    public Status createStatus(GenericValue statusGv) {
        return new StatusImpl((GenericValue)statusGv.clone(), this.translationManager, this.authenticationContext, this.baseUrl, this.statusCategoryManager);
    }

    @Override
    public Status createStatus(StatusDTO statusDTO) {
        return this.createStatus(statusDTO.toGenericValue(this.ofBizDelegator));
    }
}

