/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.fields.PriorityCreatedEvent;
import com.atlassian.jira.event.fields.PriorityDeletedEvent;
import com.atlassian.jira.event.fields.PriorityEditedEvent;
import com.atlassian.jira.event.fields.PriorityMovedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.fields.util.PrioritySchemeUtil;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityImpl;
import com.atlassian.jira.model.querydsl.PriorityDTO;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPriorityManager
extends AbstractIssueConstantsManager<Priority>
implements PriorityManager,
Startable {
    private static final String CREATION_LOCK_NAME = DefaultPriorityManager.class.getName() + ".creationLock";
    private final ApplicationProperties applicationProperties;
    private final IssueConstantFactory issueConstantFactory;
    private final ClusterLockService clusterLockService;
    private final PrioritySchemeManager prioritySchemeManager;
    private final EventPublisher eventPublisher;
    private final I18nHelper i18nHelper;
    private final ProjectManager projectManager;
    private final PrioritySchemeUtil prioritySchemeUtil;
    private ClusterLock creationLock;
    private static final Logger log = LoggerFactory.getLogger(DefaultPriorityManager.class);

    public DefaultPriorityManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexingService issueIndexingService, ApplicationProperties applicationProperties, IssueConstantFactory issueConstantFactory, ClusterLockService clusterLockService, IssueManager issueManager, QueryDslAccessor queryDslAccessor, PrioritySchemeManager prioritySchemeManager, EventPublisher eventPublisher, I18nHelper i18nHelper, ProjectManager projectManager, PrioritySchemeUtil prioritySchemeUtil) {
        super(constantsManager, ofBizDelegator, issueIndexingService, issueManager, queryDslAccessor);
        this.applicationProperties = applicationProperties;
        this.issueConstantFactory = issueConstantFactory;
        this.clusterLockService = clusterLockService;
        this.prioritySchemeManager = prioritySchemeManager;
        this.eventPublisher = eventPublisher;
        this.i18nHelper = i18nHelper;
        this.projectManager = projectManager;
        this.prioritySchemeUtil = prioritySchemeUtil;
    }

    public void start() {
        this.creationLock = this.clusterLockService.getLockForName(CREATION_LOCK_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Priority createPriority(String name, String description, String iconUrl, String color) {
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        Assertions.notBlank((String)"color", (String)color);
        this.creationLock.lock();
        try {
            Priority priority2;
            for (Priority priority2 : this.constantsManager.getPriorities()) {
                if (!name.trim().equalsIgnoreCase(priority2.getName())) continue;
                throw new IllegalStateException(this.i18nHelper.getText("priority.with.name.already.exists.description", name));
            }
            PriorityDTO priorityDto = PriorityDTO.builder().name(name).description(description).id(this.getNextStringId()).iconurl(iconUrl).statusColor(color).sequence(this.getMaxSequenceNo() + 1L).build();
            this.createConstant(priorityDto.toGenericValue(this.ofBizDelegator).getAllFields());
            priority2 = this.issueConstantFactory.createPriority(priorityDto);
            this.prioritySchemeManager.addOptionToDefault(priority2.getId());
            this.eventPublisher.publish((Object)new PriorityCreatedEvent(priority2));
            Priority priority3 = priority2;
            return priority3;
        }
        finally {
            this.creationLock.unlock();
            this.constantsManager.refreshPriorities();
        }
    }

    public void editPriority(Priority priority, String name, String description, String iconUrl, String color) {
        Assertions.notNull((String)"priority", (Object)priority);
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        Assertions.notBlank((String)"color", (String)color);
        for (Priority prio : this.getPriorities()) {
            if (!name.equalsIgnoreCase(prio.getName()) || priority.getId().equals(prio.getId())) continue;
            throw new IllegalStateException(this.i18nHelper.getText("priority.cannot.rename.already.exists.description", priority.getName()));
        }
        try {
            GenericValue priorityGV = ((PriorityImpl)priority).getGenericValue();
            PriorityImpl updatedPriority = (PriorityImpl)this.issueConstantFactory.createPriority(PriorityDTO.fromGenericValue(priorityGV));
            updatedPriority.setName(name);
            updatedPriority.setDescription(description);
            updatedPriority.setIconUrl(iconUrl);
            updatedPriority.setStatusColor(color);
            updatedPriority.getGenericValue().store();
            this.eventPublisher.publish((Object)new PriorityEditedEvent(priority, (Priority)updatedPriority));
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(this.i18nHelper.getText("priority.failed.to.update.description", priority.getName()), (Throwable)e);
        }
    }

    public List<Priority> getPriorities() {
        return Lists.newArrayList((Iterable)this.constantsManager.getPriorities());
    }

    public void removePriority(String id, String newPriorityId) {
        Assertions.notBlank((String)"id", (String)id);
        Assertions.notBlank((String)"newPriorityId", (String)newPriorityId);
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException(this.i18nHelper.getText("priority.does.not.exist.description", id));
        }
        Priority newPriority = this.getPriority(newPriorityId);
        if (newPriority == null) {
            throw new IllegalArgumentException(this.i18nHelper.getText("priority.does.not.exist.description", id));
        }
        this.prioritySchemeManager.removeOptionFromAllSchemes(id);
        try {
            this.removeConstant(QIssue.ISSUE.priority, priority, newPriority.getId());
            this.eventPublisher.publish((Object)new PriorityDeletedEvent(priority));
        }
        catch (Exception ex) {
            throw new DataAccessException(this.i18nHelper.getText("priority.failed.to.remove.description", id), (Throwable)ex);
        }
    }

    public Priority getPriority(String id) {
        Assertions.notBlank((String)"id", (String)id);
        return this.constantsManager.getPriorityObject(id);
    }

    public void setDefaultPriority(String id) {
        if (id != null && this.getPriority(id) == null) {
            throw new IllegalArgumentException(this.i18nHelper.getText("priority.does.not.exist.description", id));
        }
        this.applicationProperties.setString("jira.constant.default.priority", id);
    }

    public Priority getDefaultPriority() {
        String priorityId = this.applicationProperties.getString("jira.constant.default.priority");
        if (StringUtils.isNotEmpty((CharSequence)priorityId)) {
            Priority priority = this.getPriority(priorityId);
            if (priority == null) {
                log.warn(this.i18nHelper.getText("priority.default.does.not.exist.description"), (Object)priorityId);
            }
            return priority;
        }
        return null;
    }

    public void movePriorityUp(String id) {
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException(this.i18nHelper.getText("priority.does.not.exist.description", id));
        }
        this.moveUp(priority);
        this.eventPublisher.publish((Object)new PriorityMovedEvent(priority, priority.getSequence(), Long.valueOf(priority.getSequence() - 1L)));
    }

    public void movePriorityDown(String id) {
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException(this.i18nHelper.getText("priority.does.not.exist.description", id));
        }
        this.moveDown(priority);
        this.eventPublisher.publish((Object)new PriorityMovedEvent(priority, priority.getSequence(), Long.valueOf(priority.getSequence() + 1L)));
    }

    protected List<Priority> getValues() {
        return this.getPriorities();
    }

    @Override
    protected void postProcess(Priority priority) {
        if (priority.getId().equals(this.applicationProperties.getString("jira.constant.default.priority"))) {
            this.applicationProperties.setString("jira.constant.default.priority", null);
        }
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshPriorities();
    }

    @Override
    protected String getIssueConstantField() {
        return ConstantsManager.CONSTANT_TYPE.PRIORITY.getType();
    }

    @Override
    protected List<Priority> getAllValues() {
        return this.getPriorities();
    }

    public Stream<Priority> findPriorities(@Nonnull String substring, @Nonnull Set<Long> projectIds) {
        Stream<Priority> priorityStream = this.findPriorities(projectIds);
        if (StringUtils.isEmpty((CharSequence)substring)) {
            return priorityStream;
        }
        Pattern searchPattern = ConstantsManager.createIssueConstantNameSearchPattern((String)substring);
        return priorityStream.filter(priority -> searchPattern.matcher(priority.getNameTranslation()).matches());
    }

    private Stream<Priority> findPriorities(Set<Long> projectIds) {
        List projects = projectIds.isEmpty() ? this.projectManager.getProjects() : this.projectManager.convertToProjectObjects(projectIds);
        return this.prioritySchemeUtil.getCommonPrioritiesSorted(projects).stream().distinct();
    }
}

