/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database.jdbcurlparser;

import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.config.database.jdbcurlparser.PostgresUrlParser;
import com.atlassian.jira.exception.ParseException;

public class AuroraPostgresUrlParser
extends PostgresUrlParser {
    private static final String TARGET_SERVER_TYPE = "targetServerType";
    private static final String MASTER_ONLY = "master";

    @Override
    public String getUrl(String hostname, String port, String instance) throws ParseException {
        String url = super.getUrl(hostname, port, instance);
        return String.format("%s?%s=%s", url, TARGET_SERVER_TYPE, MASTER_ONLY);
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        DatabaseInstance instance = super.parseUrl(jdbcUrl);
        String dbInstanceName = instance.getInstance();
        String[] splitInstanceAndConnectionParams = dbInstanceName.split("\\?");
        String instanceName = splitInstanceAndConnectionParams[0];
        instance.setInstance(instanceName);
        return instance;
    }
}

