/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.filestore.loader;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.config.ConfigParseException;
import com.atlassian.jira.config.filestore.FileStoresConfig;
import com.atlassian.jira.config.filestore.FileStoresConfigHandler;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.util.FileStores;
import io.atlassian.fugue.Either;
import io.atlassian.util.concurrent.LazyReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class JiraHomeFileStoresConfigurationLoader
implements FileStoresConfigurationLoader {
    public static final String FILESTORE_CONFIG_FILENAME = "filestore-config.xml";
    private final FileStores fileStores;
    private final LazyReference<State> stateLazyRef;

    public JiraHomeFileStoresConfigurationLoader(FileStores fileStores) {
        this.fileStores = Objects.requireNonNull(fileStores);
        this.stateLazyRef = new LazyReference<State>(){

            protected State create() {
                return JiraHomeFileStoresConfigurationLoader.this.load();
            }
        };
    }

    @Override
    public boolean configExists() {
        return ((State)Objects.requireNonNull(this.stateLazyRef.get())).configExists();
    }

    @Override
    @Nonnull
    public Optional<Either<RuntimeException, FileStoresConfig>> loadConfig() {
        return ((State)this.stateLazyRef.get()).getFileStoresConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private State load() {
        if (!this.getConfigFile().tryFileExists()) {
            return State.empty();
        }
        FileStoresConfigHandler fileStoresConfigHandler = new FileStoresConfigHandler();
        try (InputStream inputStream = this.getConfigFile().fileReader().openInputStream();){
            SAXReader xmlReader = new SAXReader();
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xmlReader.setStripWhitespaceText(true);
            Element rootElement = xmlReader.read(inputStream).getRootElement();
            State state = State.of(fileStoresConfigHandler.parse(rootElement));
            return state;
        }
        catch (ConfigParseException e) {
            return State.ofError(e);
        }
        catch (DocumentException | SAXException e) {
            return State.ofError(new ConfigParseException(String.format("%s is not well-formed XML. Ensure the file is valid XML before retrying.", FILESTORE_CONFIG_FILENAME), e));
        }
        catch (IOException e) {
            return State.ofError(new ConfigParseException(String.format("Jira couldn't read the contents of the %s file. Make sure that the file permissions are properly set up. ", FILESTORE_CONFIG_FILENAME), e));
        }
    }

    private FileStore.Path getConfigFile() {
        return this.fileStores.getLocalHomeFilesystemPath().path(new String[]{FILESTORE_CONFIG_FILENAME});
    }

    static class State {
        @Nullable
        private final Either<RuntimeException, FileStoresConfig> fileStoresConfig;

        State(@Nullable Either<RuntimeException, FileStoresConfig> fileStoresConfig) {
            this.fileStoresConfig = fileStoresConfig;
        }

        static State empty() {
            return new State(null);
        }

        static State of(@Nonnull FileStoresConfig fileStoresConfig) {
            return new State((Either<RuntimeException, FileStoresConfig>)Either.right((Object)fileStoresConfig));
        }

        static State ofError(@Nonnull RuntimeException error) {
            return new State((Either<RuntimeException, FileStoresConfig>)Either.left((Object)error));
        }

        public boolean configExists() {
            return this.fileStoresConfig != null;
        }

        public Optional<Either<RuntimeException, FileStoresConfig>> getFileStoresConfig() {
            return Optional.ofNullable(this.fileStoresConfig);
        }
    }
}

