/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties.v2;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.bc.dataimport.DatabaseImportCompletedEvent;
import com.atlassian.jira.config.properties.ApplicationPropertiesManager;
import com.atlassian.jira.config.properties.ApplicationProperty;
import com.atlassian.jira.config.properties.CachingApplicationPropertiesManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class DefaultCachingApplicationPropertiesManager
implements CachingApplicationPropertiesManager,
Startable {
    private static final String ALL_CACHE_KEY = ".";
    private final ApplicationPropertiesManager delegate;
    private final Cache<String, List<ApplicationProperty>> allCache;
    private final Cache<String, Optional<ApplicationProperty>> cache;
    private final EventListenerRegistrar eventListenerRegistrar;

    @Inject
    public DefaultCachingApplicationPropertiesManager(ApplicationPropertiesManager delegate, CacheManager cacheManager, EventListenerRegistrar eventListenerRegistrar) {
        this.delegate = delegate;
        this.eventListenerRegistrar = eventListenerRegistrar;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).replicateViaInvalidation().flushable().build();
        this.cache = cacheManager.getCache(DefaultCachingApplicationPropertiesManager.class.getName() + ".cache", this::loadApplicationProperty, cacheSettings);
        this.allCache = cacheManager.getCache(DefaultCachingApplicationPropertiesManager.class.getName() + ".allCache", this::loadApplicationProperties, cacheSettings);
    }

    public void delete(String key) {
        try {
            this.delegate.delete(key);
        }
        finally {
            this.allCache.removeAll();
            this.cache.remove((Object)key);
        }
    }

    public void deleteAll() {
        try {
            this.delegate.deleteAll();
        }
        finally {
            this.allCache.removeAll();
            this.cache.removeAll();
        }
    }

    public boolean exists(String key) {
        return ((Optional)Objects.requireNonNull(this.cache.get((Object)key))).isPresent();
    }

    public void flush() {
        this.allCache.removeAll();
        this.cache.removeAll();
    }

    @Nonnull
    public Optional<ApplicationProperty> get(String key) {
        return (Optional)Objects.requireNonNull(this.cache.get((Object)key));
    }

    @Nonnull
    public Stream<ApplicationProperty> getAll() {
        return ((List)Objects.requireNonNull(this.allCache.get((Object)ALL_CACHE_KEY))).stream();
    }

    @Nonnull
    public Stream<String> getAllKeys() {
        return this.getAllKeysInternal(null, null);
    }

    @Nonnull
    public Stream<String> getAllKeys(String keyPrefix) {
        return this.getAllKeysInternal(keyPrefix, null);
    }

    @Nonnull
    public Stream<String> getAllKeys(ApplicationProperty.Type type) {
        return this.getAllKeysInternal(null, type);
    }

    @Nonnull
    public Stream<String> getAllKeys(String keyPrefix, ApplicationProperty.Type type) {
        return this.getAllKeysInternal(keyPrefix, type);
    }

    @Nonnull
    public ApplicationProperty save(ApplicationProperty property) {
        try {
            ApplicationProperty applicationProperty = this.delegate.save(property);
            return applicationProperty;
        }
        finally {
            this.allCache.removeAll();
            this.cache.remove((Object)property.getKey());
        }
    }

    public void start() throws Exception {
        this.eventListenerRegistrar.register((Object)this);
    }

    @EventListener
    public void onClearCache(@Nullable ClearCacheEvent event) {
        this.flush();
    }

    @EventListener
    public void onDatabaseImportCompleted(DatabaseImportCompletedEvent event) {
        this.flush();
    }

    @Nonnull
    private Stream<String> getAllKeysInternal(@Nullable String keyPrefix, @Nullable ApplicationProperty.Type type) {
        Stream<Object> propertyStream = ((List)Objects.requireNonNull(this.allCache.get((Object)ALL_CACHE_KEY))).stream();
        if (type != null) {
            propertyStream = propertyStream.filter(p -> p.getType().equals((Object)type));
        }
        Stream<String> keyStream = propertyStream.map(ApplicationProperty::getKey);
        return keyPrefix != null ? keyStream.filter(key -> key.startsWith(keyPrefix)) : keyStream;
    }

    @Nonnull
    private Optional<ApplicationProperty> loadApplicationProperty(String key) {
        return this.delegate.get(key);
    }

    @Nonnull
    private List<ApplicationProperty> loadApplicationProperties(String dummyKey) {
        return this.delegate.getAll().collect(Collectors.toList());
    }
}

