/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.config.util.JiraHome;
import java.io.File;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultAttachmentConfigManager
implements AttachmentConfigManager {
    private static final String TMP_ATTACHMENTS = "tmp_attachments";
    private final AttachmentConfigStore attachmentConfigStore;
    private final JiraHome jiraHome;

    public static String getDefaultTempAttachmentDirectory() {
        return TMP_ATTACHMENTS;
    }

    public DefaultAttachmentConfigManager(AttachmentConfigStore attachmentConfigStore, JiraHome jiraHome) {
        this.attachmentConfigStore = Objects.requireNonNull(attachmentConfigStore);
        this.jiraHome = Objects.requireNonNull(jiraHome);
    }

    public boolean isAttachmentsEnabled() {
        return this.attachmentConfigStore.getConfig().isAttachmentsEnabled();
    }

    public long getMaxAttachmentSize() {
        return this.attachmentConfigStore.getConfig().getMaxAttachmentSize();
    }

    public boolean isThumbnailsEnabled() {
        return this.attachmentConfigStore.getConfig().isThumbnailsEnabled();
    }

    public boolean isAttachmentsDownloadableAsZip() {
        return this.attachmentConfigStore.getConfig().isZipSupportEnabled();
    }

    public File getTemporaryAttachmentDirectory() {
        File cachesDirectory = this.jiraHome.getCachesDirectory();
        File tempDirectory = new File(cachesDirectory, TMP_ATTACHMENTS);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
        return tempDirectory;
    }
}

