/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import java.util.Hashtable;
import java.util.Map;
import org.slf4j.LoggerFactory;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.config.Configuration;

public class JiraAliasingActionFactoryProxy
extends ActionFactoryProxy {
    Map actionAliases = new Hashtable();
    boolean aliasingOnly;

    public JiraAliasingActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
        try {
            this.aliasingOnly = Boolean.valueOf(Configuration.getString((String)"webwork.aliasing.only"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Action getActionImpl(String aName) throws Exception {
        String actionName = (String)this.actionAliases.get(aName);
        if (actionName == null) {
            try {
                actionName = Configuration.getString((String)(aName + "." + Configuration.getString((String)"webwork.action.extension")));
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Aliasing only:" + this.aliasingOnly);
                if (this.aliasingOnly) {
                    // empty if block
                }
                actionName = aName;
            }
            this.actionAliases.put(aName, actionName);
        }
        return this.getNextFactory().getActionImpl(actionName);
    }

    public void flushCaches() {
        this.getNextFactory().flushCaches();
        this.actionAliases.clear();
    }
}

