/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.encryptors;

import com.atlassian.crowd.crypto.PrefixBasedSwitchableEncryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.jira.crowd.embedded.encryptors.ConcreteEncryptorsFactory;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.map.LazyMap;

public class LazyLoadingPrefixBasedEncryptor
extends PrefixBasedSwitchableEncryptor {
    private final ConcreteEncryptorsFactory encryptorsFactory;

    public LazyLoadingPrefixBasedEncryptor(EncryptionSettings encryptionSettings, ConcreteEncryptorsFactory encryptorsFactory) {
        super(encryptionSettings, LazyMap.decorate(new HashMap(), key -> encryptorsFactory.createEncryptor((String)key).orElse(null)));
        this.encryptorsFactory = encryptorsFactory;
    }

    public void switchEncryptor(String encryptorKey) {
        if (encryptorKey != null && this.getAvailableEncryptorKeys().contains(encryptorKey)) {
            this.getEncryptor(encryptorKey);
        }
        super.switchEncryptor(encryptorKey);
    }

    public Collection<String> getAvailableEncryptorKeys() {
        return this.encryptorsFactory.getAvailableEncryptors();
    }
}

