/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.jira.util.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class ExponentialBatchProcessingUtil {
    private static final int BATCH_SIZE_THRESHOLD = 8;

    ExponentialBatchProcessingUtil() {
    }

    public static <R, E> R processBatches(Collection<E> col, Function<Integer, R> accumulatorSupplier, BatchProcessor<R, E> processor) {
        int tailSize;
        int batchSize;
        Object accumulator = accumulatorSupplier.apply((Object)col.size());
        Iterator<E> tailIterator = col.iterator();
        for (tailSize = col.size(); tailSize > 8; tailSize -= batchSize) {
            batchSize = Integer.highestOneBit(tailSize);
            accumulator = processor.process(accumulator, ExponentialBatchProcessingUtil.getBatch(tailIterator, batchSize));
        }
        if (tailSize > 0) {
            accumulator = processor.process(accumulator, ExponentialBatchProcessingUtil.getBatch(tailIterator, tailSize));
        }
        return (R)accumulator;
    }

    private static <T> List<T> getBatch(Iterator<T> iterator, int batchSize) {
        ArrayList result = Lists.newArrayListWithCapacity((int)batchSize);
        for (int i = 0; i < batchSize; ++i) {
            result.add(iterator.next());
        }
        return result;
    }

    @FunctionalInterface
    static interface BatchProcessor<R, E> {
        public R process(R var1, Collection<E> var2);
    }
}

