/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.DelegatingUserWithAttributes;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.UserEventHandlerImpl;
import com.atlassian.jira.cluster.cache.pauser.ClusteredReplicationPauserManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.crowd.embedded.ofbiz.AttributeKey;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.EagerOfBizUserCache;
import com.atlassian.jira.crowd.embedded.ofbiz.ExponentialBatchProcessingUtil;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.LazyOfBizUserCache;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizAttributesBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUserCache;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.SimpleUserOrGroupStub;
import com.atlassian.jira.crowd.embedded.ofbiz.UnsortedRestriction;
import com.atlassian.jira.crowd.embedded.ofbiz.UserAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntityConditionFactory;
import com.atlassian.jira.crowd.embedded.ofbiz.UserNotFoundException;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizTransaction;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizTransactionManager;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.event.user.BeforeUserAuthenticate;
import com.atlassian.jira.event.user.UsersAddedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserDeleteVeto;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Pair;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizUserDao
implements ExtendedUserDao {
    private static final Logger log = LoggerFactory.getLogger(OfBizUserDao.class);
    private static final List<String> ORDER_BY_ATTRIBUTE_ID = ImmutableList.of((Object)"id");
    private static final String DELETED_EXTERNALLY_SUFFIX = " [X]";
    private static final int PROCESS_USERS_FETCH_SIZE = 1000;
    final OfBizDelegator ofBizDelegator;
    final DirectoryDao directoryDao;
    private final InternalMembershipDao membershipDao;
    private final UserKeyStore userKeyStore;
    private final UserDeleteVeto userDeleteVeto;
    private final ApplicationProperties applicationProperties;
    private final OfBizTransactionManager ofBizTransactionManager;
    private final DatabaseConfig databaseConfig;
    private final EventPublisher eventPublisher;
    private final OfBizUserCache userCaseInsensitiveCache;
    private final Cache<AttributeKey, Attributes> userAttributesCache;
    private final boolean primaryUserDao;
    static final Function<GenericValue, String> TO_USERNAME_FUNCTION = gvUser -> gvUser.getString("userName");
    static final Function<GenericValue, OfBizUser> TO_USER_FUNCTION = OfBizUser::from;
    static final Function<GenericValue, String> TO_USERNAME_INTERNED_FUNCTION = gvUser -> {
        String userName = gvUser.getString("userName");
        return OfBizUser.internString(userName);
    };
    static final Function<GenericValue, OfBizUser> TO_USER_INTERNED_FUNCTION = gvUser -> OfBizUser.from(gvUser, true);

    public OfBizUserDao(OfBizDelegator ofBizDelegator, DirectoryDao directoryDao, InternalMembershipDao membershipDao, UserKeyStore userKeyStore, UserDeleteVeto userDeleteVeto, CacheManager cacheManager, ClusterLockService clusterLockService, ApplicationProperties applicationProperties, OfBizTransactionManager ofBizTransactionManager, DatabaseConfigurationManager databaseConfigurationManager, EventPublisher eventPublisher, boolean primaryUserDao) {
        this.ofBizDelegator = ofBizDelegator;
        this.directoryDao = directoryDao;
        this.membershipDao = membershipDao;
        this.userKeyStore = userKeyStore;
        this.userDeleteVeto = userDeleteVeto;
        this.applicationProperties = applicationProperties;
        this.ofBizTransactionManager = ofBizTransactionManager;
        this.databaseConfig = databaseConfigurationManager.getDatabaseConfiguration();
        this.eventPublisher = eventPublisher;
        this.primaryUserDao = primaryUserDao;
        eventPublisher.register((Object)this);
        this.userAttributesCache = cacheManager.getCache(OfBizUserDao.class.getName() + ".userAttributesCache", (CacheLoader)new UserAttributesCacheLoader(), new CacheSettingsBuilder().local().expireAfterWrite(10L, TimeUnit.SECONDS).flushable().build());
        if (this.useFullCache()) {
            log.info("Using full user cache");
            this.userCaseInsensitiveCache = new EagerOfBizUserCache(clusterLockService, cacheManager, directoryDao, ofBizDelegator);
        } else {
            log.info("Using lazy user cache");
            this.userCaseInsensitiveCache = new LazyOfBizUserCache(cacheManager, ofBizDelegator);
        }
    }

    @EventListener
    public void onBeforeUserAuthenticate(BeforeUserAuthenticate beforeUserAuthenticate) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String username = beforeUserAuthenticate.getUsername();
        new ClusteredReplicationPauserManager().pauseReplicationFor(() -> this.findByLoginInDb(username).forEach(this.userCaseInsensitiveCache::refresh), beforeUserAuthenticate.toString());
    }

    @Nonnull
    public List<OfBizUser> findByLoginInDb(String username) {
        List users = Select.columns(OfBizUser.SUPPORTED_FIELDS).from("User").whereEqual("lowerUserName", username.toLowerCase()).runWith(this.ofBizDelegator).asList();
        return users.stream().map(OfBizUser::from).collect(Collectors.toList());
    }

    @Override
    public boolean useFullCache() {
        return this.applicationProperties.getOption("jira.fullUserCache");
    }

    @Override
    public boolean useInternedUserValues() {
        return this.applicationProperties.getOption("jira.internUserValues");
    }

    @Nonnull
    public TimestampedUser findByName(long directoryId, String userName) throws UserNotFoundException {
        return this.findOfBizUser(directoryId, userName);
    }

    @Override
    @Nonnull
    public OfBizUser findOfBizUser(long directoryId, String userName) throws UserNotFoundException {
        OfBizUser user = this.findByNameOrNull(directoryId, userName);
        if (user == null) {
            throw new UserNotFoundException(userName);
        }
        return user;
    }

    @Override
    @Nullable
    public OfBizUser findByNameOrNull(long directoryId, @Nonnull String userName) {
        return this.userCaseInsensitiveCache.getCaseInsensitive(directoryId, userName);
    }

    @Override
    @Nonnull
    public List<OfBizUser> findAllByNameOrNull(long directoryId, @Nonnull Collection<String> userNames) {
        return this.userCaseInsensitiveCache.getAllCaseInsensitive(directoryId, userNames);
    }

    @Nonnull
    public Set<Long> findDirectoryIdsContainingUserName(String username) {
        HashSet<Long> result = new HashSet<Long>();
        Select.columns("directoryId").from("User").whereEqual("lowerUserName", IdentifierUtils.toLowerCase((String)username)).runWith(this.ofBizDelegator).forEach(gv -> result.add(gv.getLong("directoryId")));
        return result;
    }

    @Nonnull
    public Map<String, String> findByExternalIds(long directoryId, Set<String> externalIds) {
        ExponentialBatchProcessingUtil.BatchProcessor operation = (resultAccumulator, batch) -> {
            Select.columns("externalId", "userName").from("User").whereEqual("directoryId", directoryId).andCondition((EntityCondition)new EntityExpr("externalId", EntityOperator.IN, (Object)batch)).runWith(this.ofBizDelegator).forEach(gv -> resultAccumulator.put(gv.getString("externalId"), gv.getString("userName")));
            return resultAccumulator;
        };
        return ExponentialBatchProcessingUtil.processBatches(externalIds, HashMap::new, operation);
    }

    @Nonnull
    public OfBizUser findByExternalId(long directoryId, String externalId) throws UserNotFoundException {
        GenericValue user = (GenericValue)Select.columns(OfBizUser.SUPPORTED_FIELDS).from("User").whereEqual("directoryId", directoryId).andEqual("externalId", externalId).runWith(this.ofBizDelegator).singleValue();
        if (user == null) {
            throw new UserNotFoundException(externalId);
        }
        return OfBizUser.from(user);
    }

    @Override
    @Nullable
    public OfBizUser findById(long internalUserId) {
        GenericValue user = this.getUserByInternalId(internalUserId);
        if (user == null) {
            return null;
        }
        return OfBizUser.from(user);
    }

    @Nonnull
    public UserWithAttributes findByNameWithAttributes(long directoryId, String userName) throws UserNotFoundException {
        return this.getUserWithAttributes(this.findOfBizUser(directoryId, userName));
    }

    @Nullable
    public PasswordCredential getCredential(long directoryId, String userName) throws UserNotFoundException {
        GenericValue credentials = (GenericValue)Select.columns("credential").from("User").whereEqual("directoryId", directoryId).andEqual("lowerUserName", IdentifierUtils.toLowerCase((String)userName)).runWith(this.ofBizDelegator).singleValue();
        if (credentials == null) {
            throw new UserNotFoundException(userName);
        }
        String storedCredential = credentials.getString("credential");
        return storedCredential != null ? new PasswordCredential(storedCredential, true) : null;
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String userName) throws UserNotFoundException {
        throw new UnsupportedOperationException("JIRA does not store User Credential History");
    }

    private Pair<String, com.atlassian.crowd.model.user.User> doAddUser(com.atlassian.crowd.model.user.User user, PasswordCredential credential) throws UserAlreadyExistsException {
        if (credential != null) {
            Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted", (Object[])new Object[0]);
        }
        this.throwIfUserAlreadyExists(user);
        try {
            String userKey = this.userKeyStore.ensureUniqueKeyForNewUser(user.getName());
            Timestamp currentTimestamp = OfBizUserDao.getCurrentTimestamp();
            Map<String, Object> userData = UserEntity.getData(user, credential, currentTimestamp, currentTimestamp);
            GenericValue gvUser = this.ofBizDelegator.createValue("User", userData);
            OfBizUser newUser = OfBizUser.from(gvUser);
            this.userCaseInsensitiveCache.refresh(newUser);
            return Pair.pair((Object)userKey, (Object)newUser);
        }
        catch (DataAccessException ex) {
            this.throwIfUserAlreadyExists(user);
            throw ex;
        }
    }

    public com.atlassian.crowd.model.user.User add(com.atlassian.crowd.model.user.User user, PasswordCredential credential) throws UserAlreadyExistsException {
        Pair<String, com.atlassian.crowd.model.user.User> newUser = this.doAddUser(user, credential);
        if (this.primaryUserDao) {
            this.eventPublisher.publish((Object)new UsersAddedEvent(new UsersAddedEvent.AddedUser((String)newUser.left(), ((com.atlassian.crowd.model.user.User)newUser.right()).getEmailAddress())));
        }
        return (com.atlassian.crowd.model.user.User)newUser.right();
    }

    @Nonnull
    public BatchResult<com.atlassian.crowd.model.user.User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        BatchResult results = new BatchResult(users.size());
        HashMap<Object, Object> userToKeyMap = new HashMap<Object, Object>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                Pair<String, com.atlassian.crowd.model.user.User> addedUser = this.doAddUser((com.atlassian.crowd.model.user.User)user, user.getCredential());
                if (this.primaryUserDao) {
                    userToKeyMap.putIfAbsent(addedUser.right(), addedUser.left());
                }
                results.addSuccess(addedUser.right());
            }
            catch (UserAlreadyExistsException | DataAccessException | IllegalArgumentException e) {
                results.addFailure((Object)user);
                log.debug("Exception trying to add user '{}'", (Object)user.getName(), (Object)e);
            }
        }
        Set addedUsers = userToKeyMap.entrySet().stream().map(entry -> new UsersAddedEvent.AddedUser((String)entry.getValue(), ((com.atlassian.crowd.model.user.User)entry.getKey()).getEmailAddress())).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(addedUsers)) {
            this.eventPublisher.publish((Object)new UsersAddedEvent(addedUsers));
        }
        return results;
    }

    private void throwIfUserAlreadyExistsByField(long directoryId, String fieldName, String fieldValue) throws UserAlreadyExistsException {
        String existingUserName = (String)Select.stringColumn("userName").from("User").whereEqual("directoryId", directoryId).andEqual(fieldName, fieldValue).runWith(this.ofBizDelegator).singleValue();
        if (existingUserName != null) {
            throw new UserAlreadyExistsException(directoryId, existingUserName);
        }
    }

    private void throwIfUserAlreadyExists(com.atlassian.crowd.model.user.User user) throws UserAlreadyExistsException {
        long directoryId = user.getDirectoryId();
        String externalId = user.getExternalId();
        if (StringUtils.isNotEmpty((CharSequence)externalId)) {
            this.throwIfUserAlreadyExistsByField(directoryId, "externalId", externalId);
        }
        this.throwIfUserAlreadyExistsByField(directoryId, "lowerUserName", IdentifierUtils.toLowerCase((String)user.getName()));
    }

    private void setUpdatedDateToNow(long userId) {
        Update.into("User").set("updatedDate", OfBizUserDao.getCurrentTimestamp()).whereEqual("id", userId).execute(this.ofBizDelegator);
    }

    public void storeAttributes(com.atlassian.crowd.model.user.User user, Map<String, Set<String>> attributes, boolean updateTimestamp) throws UserNotFoundException {
        Long userId = this.findUserId(user);
        for (Map.Entry<String, Set<String>> entry : ((Map)Assertions.notNull(attributes)).entrySet()) {
            this.updateAttribute(userId, user, entry);
        }
        if (updateTimestamp) {
            this.setUpdatedDateToNow(userId);
        }
        this.userAttributesCache.remove((Object)new AttributeKey(user.getDirectoryId(), userId));
    }

    private void updateAttribute(Long userId, com.atlassian.crowd.model.user.User user, Map.Entry<String, Set<String>> attribute) throws UserNotFoundException {
        GenericValue attributeGv;
        int i;
        List<GenericValue> oldAttributes = this.getAttributeValues(userId, attribute.getKey(), ORDER_BY_ATTRIBUTE_ID);
        int oldSize = oldAttributes.size();
        int newSize = attribute.getValue().size();
        int commonSize = Math.min(newSize, oldSize);
        Iterator<String> newValues = attribute.getValue().iterator();
        for (i = 0; i < commonSize; ++i) {
            attributeGv = oldAttributes.get(i);
            String oldValue = attributeGv.getString("value");
            String newValue = newValues.next();
            if (StringUtils.isNotEmpty((CharSequence)newValue)) {
                if (newValue.equals(oldValue)) continue;
                attributeGv.set("value", (Object)newValue);
                attributeGv.set("lowerValue", (Object)IdentifierUtils.toLowerCase((String)newValue));
                this.ofBizDelegator.store(attributeGv);
                continue;
            }
            this.ofBizDelegator.removeValue(attributeGv);
        }
        for (i = commonSize; i < newSize; ++i) {
            String newValue = newValues.next();
            if (!StringUtils.isNotEmpty((CharSequence)newValue)) continue;
            this.storeAttributeValue(user.getDirectoryId(), userId, attribute.getKey(), newValue);
        }
        for (i = commonSize; i < oldSize; ++i) {
            attributeGv = oldAttributes.get(i);
            this.ofBizDelegator.removeValue(attributeGv);
        }
    }

    private void storeAttributeValue(Long directoryId, Long userId, String name, String value) throws UserNotFoundException {
        this.ofBizDelegator.createValue("UserAttribute", UserAttributeEntity.getData(directoryId, userId, name, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeForAllInDirectory(long directoryId, String attrName, String attrValue) {
        try {
            new SetAttributeForAllInDirectoryOperation(directoryId, attrName, attrValue).perform();
        }
        finally {
            this.userAttributesCache.removeAll();
        }
    }

    public com.atlassian.crowd.model.user.User update(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        return this.update(user, true);
    }

    @Override
    public com.atlassian.crowd.model.user.User update(com.atlassian.crowd.model.user.User user, boolean useJiraExtensions) throws UserNotFoundException {
        GenericValue oldUserGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        GenericValue newUserGenericValue = UserEntity.setData(user, (GenericValue)oldUserGenericValue.clone());
        if (useJiraExtensions && this.userDeletedExternally(oldUserGenericValue)) {
            newUserGenericValue.set("deletedExternally", (Object)0);
            newUserGenericValue.set("active", (Object)1);
        }
        newUserGenericValue.set("userName", (Object)oldUserGenericValue.getString("userName"));
        newUserGenericValue.set("updatedDate", (Object)OfBizUserDao.getCurrentTimestamp());
        OfBizUser newUser = OfBizUser.from(this.storeUser(newUserGenericValue));
        this.userCaseInsensitiveCache.refresh(newUser);
        return newUser;
    }

    public void updateCredential(com.atlassian.crowd.model.user.User user, PasswordCredential credential, int credentialHistory) throws UserNotFoundException {
        Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted", (Object[])new Object[0]);
        GenericValue storeGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        storeGenericValue.set("credential", (Object)credential.getCredential());
        this.storeUser(storeGenericValue);
    }

    private GenericValue storeUser(GenericValue userGenericValue) {
        this.ofBizDelegator.store(userGenericValue);
        return userGenericValue;
    }

    public com.atlassian.crowd.model.user.User rename(com.atlassian.crowd.model.user.User oldUser, String newName) throws UserNotFoundException {
        boolean updateAppUserMapping;
        long directoryId = oldUser.getDirectoryId();
        if (IdentifierUtils.equalsInLowerCase((String)newName, (String)oldUser.getName())) {
            updateAppUserMapping = false;
        } else if (this.userKeyStore.getKeyForUsername(newName) == null) {
            updateAppUserMapping = true;
        } else {
            boolean userWillBeShadowed = this.userIsShadowed(newName, directoryId);
            boolean userAlreadyExistsInThisDirectory = this.userExists(newName, directoryId);
            if (userWillBeShadowed) {
                updateAppUserMapping = false;
                if (userAlreadyExistsInThisDirectory) {
                    this.remove((com.atlassian.crowd.model.user.User)this.findOfBizUser(directoryId, newName));
                }
            } else {
                updateAppUserMapping = true;
                String newNameWithQualifier = this.handleAppUserEviction(newName);
                if (userAlreadyExistsInThisDirectory) {
                    this.updateUsernameInCwdTables(directoryId, newName, newNameWithQualifier);
                }
            }
        }
        OfBizUser newUser = this.updateUsernameInCwdTables(directoryId, oldUser.getName(), newName);
        if (updateAppUserMapping) {
            boolean userIsCurrentlyShadowed = this.userIsShadowed(oldUser.getName(), directoryId);
            if (userIsCurrentlyShadowed) {
                this.userKeyStore.ensureUniqueKeyForNewUser(newName);
            } else {
                this.userKeyStore.renameUser(oldUser.getName(), newName);
                if (this.userExistsInAnyDirectory(oldUser.getName())) {
                    this.userKeyStore.ensureUniqueKeyForNewUser(oldUser.getName());
                }
            }
        }
        return newUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfBizUser updateUsernameInCwdTables(long directoryId, String oldName, String newName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(directoryId, oldName);
        userGenericValue.set("userName", (Object)newName);
        userGenericValue.set("lowerUserName", (Object)IdentifierUtils.toLowerCase((String)newName));
        userGenericValue.set("updatedDate", (Object)OfBizUserDao.getCurrentTimestamp());
        OfBizUser newUser = OfBizUser.from(this.storeUser(userGenericValue));
        try {
            this.updateGroupMembership(directoryId, oldName, newName);
        }
        finally {
            this.userCaseInsensitiveCache.remove(directoryId, oldName);
        }
        this.userCaseInsensitiveCache.refresh(newUser);
        return newUser;
    }

    protected void updateGroupMembership(long directoryId, String oldName, String newName) {
        FieldMap whereClause = FieldMap.build((String)"directoryId", (Object)directoryId).add("lowerChildName", (Object)IdentifierUtils.toLowerCase((String)oldName)).add("membershipType", (Object)MembershipType.GROUP_USER.name());
        List oldMemberships = this.ofBizDelegator.findByAnd("Membership", (Map)whereClause);
        this.membershipDao.removeAllUserMemberships(directoryId, oldName);
        for (GenericValue oldMembership : oldMemberships) {
            SimpleUserOrGroupStub userStub = new SimpleUserOrGroupStub(oldMembership.getLong("childId"), directoryId, newName);
            SimpleUserOrGroupStub groupStub = new SimpleUserOrGroupStub(oldMembership.getLong("parentId"), directoryId, oldMembership.getString("parentName"));
            try {
                this.membershipDao.addUserToGroup(directoryId, userStub, groupStub);
            }
            catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {}
        }
    }

    private boolean userExistsInAnyDirectory(String username) {
        return Select.id().from("User").whereEqual("lowerUserName", IdentifierUtils.toLowerCase((String)username)).runWith(this.ofBizDelegator).count() > 0L;
    }

    private boolean userIsShadowed(String name, long directoryId) {
        for (Directory directory : this.directoryDao.findAll()) {
            if (directory.getId() == directoryId) {
                return false;
            }
            if (this.findByNameOrNull(directory.getId(), name) == null) continue;
            return true;
        }
        return false;
    }

    private String handleAppUserEviction(String fromUsername) {
        int count = 1;
        String toUsername = fromUsername + "#1";
        while (this.userKeyStore.getKeyForUsername(toUsername) != null) {
            if (count == Integer.MAX_VALUE) {
                throw new IllegalStateException("App user user eviction namespace exhausted");
            }
            toUsername = fromUsername + '#' + ++count;
        }
        this.userKeyStore.renameUser(fromUsername, toUsername);
        return toUsername;
    }

    public BatchResult<String> removeAllUsers(long directoryId, Set<String> userNames) {
        BatchResult results = new BatchResult(userNames.size());
        for (String userName : userNames) {
            try {
                this.remove((com.atlassian.crowd.model.user.User)this.findOfBizUser(directoryId, userName));
                results.addSuccess((Object)userName);
            }
            catch (UserNotFoundException e) {
                results.addFailure((Object)userName);
                log.debug("Exception trying to remove user '{}'", (Object)userName, (Object)e);
            }
        }
        return results;
    }

    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        this.directoryDao.findById(directoryId);
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        Select.stringColumn("externalId").from("User").whereEqual("directoryId", directoryId).runWith(this.ofBizDelegator).visitWith(new Visitor<String>(){

            public void visit(String externalId) {
                if (externalId != null) {
                    builder.add((Object)externalId);
                }
            }
        });
        return builder.build();
    }

    public long getUserCount(long directoryId) throws DirectoryNotFoundException {
        this.directoryDao.findById(directoryId);
        return Select.from("User").whereEqual("directoryId", directoryId).runWith(this.ofBizDelegator).count();
    }

    @Override
    public long getUniqueUserCount(Set<Long> directoryIds) throws DirectoryNotFoundException {
        for (long directoryId : directoryIds) {
            this.directoryDao.findById(directoryId);
        }
        return ((GenericValue)Select.columns("count").from("UserNameCount").whereCondition((EntityCondition)new EntityExpr("directoryId", EntityOperator.IN, directoryIds)).runWith(this.ofBizDelegator).singleValue()).getLong("count");
    }

    public void removeAttribute(com.atlassian.crowd.model.user.User user, String attributeName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        Long userId = userGenericValue.getLong("id");
        this.ofBizDelegator.removeByAnd("UserAttribute", PrimitiveMap.of("userId", (long)userGenericValue.getLong("id"), "name", attributeName));
        this.setUpdatedDateToNow(userId);
        this.userAttributesCache.remove((Object)new AttributeKey(user.getDirectoryId(), userId));
    }

    private List<GenericValue> getAttributeValues(Long userId, String attributeName, List<String> orderBy) throws UserNotFoundException {
        return this.ofBizDelegator.findByAnd("UserAttribute", PrimitiveMap.of("userId", (long)userId, "name", attributeName), orderBy);
    }

    public void remove(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        if (!this.allowDeleteUser(user)) {
            this.disableUserDeletedExternally(user);
            return;
        }
        Long userId = this.findUserId(user);
        this.membershipDao.removeAllUserMemberships(user);
        this.ofBizDelegator.removeByAnd("UserAttribute", PrimitiveMap.of("userId", userId));
        int rows = Delete.from("User").whereEqual("directoryId", user.getDirectoryId()).andEqual("lowerUserName", OfBizUserDao.getLowerUserName(user)).execute(this.ofBizDelegator);
        if (rows == 0) {
            throw new UserNotFoundException(user.getName());
        }
        this.userCaseInsensitiveCache.remove(DirectoryEntityKey.getKeyLowerCase((DirectoryEntity)user));
        this.userAttributesCache.remove((Object)new AttributeKey(user.getDirectoryId(), userId));
        ((AuditingManager)ComponentAccessor.getComponent(AuditingManager.class)).store(new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.deleted").withActionI18nKey("jira.auditing.user.deleted").forObject((AssociatedItem)new AffectedUser(user)));
    }

    private boolean allowDeleteUser(com.atlassian.crowd.model.user.User user) {
        return this.userExistsInAnotherActiveDirectory(user) || this.userDeleteVeto.allowDeleteUser(ApplicationUsers.from((User)user));
    }

    private boolean userExistsInAnotherActiveDirectory(com.atlassian.crowd.model.user.User user) {
        for (Directory directory : this.directoryDao.findAll()) {
            OfBizUser userInDirectory;
            long directoryId = directory.getId();
            if (!directory.isActive() || directoryId == user.getDirectoryId() || (userInDirectory = this.findByNameOrNull(directoryId, user.getName())) == null) continue;
            return true;
        }
        return false;
    }

    private void disableUserDeletedExternally(com.atlassian.crowd.model.user.User user) {
        GenericValue userGenericValue;
        try {
            userGenericValue = UserEntity.setData(user, this.findUserGenericValue(user.getDirectoryId(), user.getName()));
        }
        catch (UserNotFoundException e) {
            return;
        }
        if (this.userDeletedExternally(userGenericValue)) {
            return;
        }
        OfBizUser oldUser = OfBizUser.from(userGenericValue);
        userGenericValue.set("updatedDate", (Object)OfBizUserDao.getCurrentTimestamp());
        userGenericValue.set("active", (Object)0);
        userGenericValue.set("deletedExternally", (Object)1);
        String displayName = user.getDisplayName();
        if (!displayName.endsWith(DELETED_EXTERNALLY_SUFFIX)) {
            userGenericValue.set("displayName", (Object)(user.getDisplayName() + DELETED_EXTERNALLY_SUFFIX));
        }
        OfBizUser newUser = OfBizUser.from(this.storeUser(userGenericValue));
        this.userCaseInsensitiveCache.refresh(newUser);
        ImmutableList<ChangedValue> changedValues = new ChangedValuesBuilder().addIfDifferent("common.words.fullname", oldUser.getDisplayName(), newUser.getDisplayName()).addIfDifferent("admin.common.phrases.active.inactive", UserEventHandlerImpl.stringBooleanToActiveInactive(oldUser.isActive()), UserEventHandlerImpl.stringBooleanToActiveInactive(newUser.isActive())).build();
        if (!changedValues.isEmpty()) {
            ((AuditingManager)ComponentAccessor.getComponent(AuditingManager.class)).store(new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.updated").withActionI18nKey("jira.auditing.user.updated").withChangedValues(changedValues).forObject((AssociatedItem)new AffectedUser(user)));
        }
    }

    private boolean userDeletedExternally(@Nonnull GenericValue userGenericValue) {
        Integer i = userGenericValue.getInteger("deletedExternally");
        return i != null && i != 0;
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        Validate.isTrue((query.getEntityDescriptor().getEntityType() == Entity.USER ? 1 : 0) != 0, (String)"UserDao can only evaluate EntityQueries for Entity.USER", (Object[])new Object[0]);
        SearchRestriction searchRestriction = query.getSearchRestriction();
        EntityCondition baseCondition = new UserEntityConditionFactory(this.ofBizDelegator).getEntityConditionFor(searchRestriction);
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        ArrayList<Object> entityConditions = new ArrayList<Object>(2);
        if (baseCondition != null) {
            entityConditions.add(baseCondition);
        }
        entityConditions.add(directoryCondition);
        EntityConditionList entityCondition = new EntityConditionList(entityConditions, EntityOperator.AND);
        EntityFindOptions findOptions = new EntityFindOptions();
        findOptions.setOffset(query.getStartIndex());
        if (query.getMaxResults() >= 0) {
            findOptions.setMaxResults(query.getMaxResults());
        }
        List<String> sortFields = searchRestriction instanceof UnsortedRestriction ? null : Collections.singletonList("lowerUserName");
        List<String> fieldsToSelect = query.getReturnType().equals(String.class) ? Collections.singletonList("userName") : null;
        ArrayList results = new ArrayList();
        this.ofBizTransactionManager.withTransaction(arg_0 -> this.lambda$search$5(findOptions, (EntityCondition)entityCondition, fieldsToSelect, sortFields, results, arg_0));
        Class resultType = query.getReturnType();
        Function<GenericValue, ?> mapperForUsers = this.getMapperForUsers(query);
        return (List)results.stream().map(gv -> resultType.cast(mapperForUsers.apply(gv))).collect(CollectorsUtil.toImmutableList());
    }

    private Function<GenericValue, ?> getMapperForUsers(EntityQuery query) {
        Class queryReturnType = query.getReturnType();
        if (queryReturnType.equals(String.class)) {
            return this.useInternedUserValues() ? TO_USERNAME_INTERNED_FUNCTION : TO_USERNAME_FUNCTION;
        }
        Function userFunction = this.useInternedUserValues() ? TO_USER_INTERNED_FUNCTION : TO_USER_FUNCTION;
        return UserWithAttributes.class.isAssignableFrom(queryReturnType) ? gv -> this.getUserWithAttributes((OfBizUser)userFunction.apply(gv)) : userFunction;
    }

    private UserWithAttributes getUserWithAttributes(OfBizUser user) {
        Attributes attributes = (Attributes)this.userAttributesCache.get((Object)new AttributeKey(user.getDirectoryId(), user.getId()));
        return new DelegatingUserWithAttributes((com.atlassian.crowd.model.user.User)user, attributes);
    }

    @Override
    public Collection<String> findNamesOfUsersInGroups(Collection<String> groupNames) {
        HashSet<String> results = new HashSet<String>();
        List groupNamesLowerCase = groupNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toList());
        EntityExpr membershipTypeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)MembershipType.GROUP_USER.name());
        EntityExpr nameCondition = new EntityExpr("lowerParentName", EntityOperator.IN, groupNamesLowerCase);
        EntityExprList condition = new EntityExprList((List)ImmutableList.of((Object)membershipTypeCondition, (Object)nameCondition), EntityOperator.AND);
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, (Collection)ImmutableSet.of((Object)"lowerChildName"), null, null);){
            GenericValue curItem;
            do {
                if ((curItem = iterator.next()) == null) continue;
                results.add(curItem.getString("lowerChildName"));
            } while (curItem != null);
        }
        return results;
    }

    @Override
    public Collection<String> getAllAttributeKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("UserAttribute", null, null, Collections.singleton("name"), null, EntityFindOptions.findOptions().distinct());){
            GenericValue gv;
            do {
                if ((gv = iterator.next()) == null) continue;
                keys.add(gv.getString("name"));
            } while (gv != null);
        }
        return keys;
    }

    private void configureDatabaseStreaming(EntityFindOptions findOptions) {
        if (this.databaseConfig.isMySql()) {
            findOptions.setFetchSize(Integer.MIN_VALUE);
        } else {
            findOptions.setFetchSize(1000);
        }
    }

    @Override
    public void processUsers(Consumer<? super com.atlassian.crowd.model.user.User> userProcessor) {
        EntityExpr directoryCondition = new EntityExpr("directoryActive", EntityOperator.NOT_EQUAL, (Object)0);
        EntityFindOptions efo = EntityFindOptions.findOptions();
        this.configureDatabaseStreaming(efo);
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("UserWithDirectory", (EntityCondition)directoryCondition, null, null, (List)ImmutableList.of((Object)"lowerUserName", (Object)"position"), efo);){
            GenericValue gv;
            OfBizUser curUser = null;
            do {
                if ((gv = iterator.next()) == null) continue;
                String gvUserName = gv.getString("lowerUserName");
                if (curUser != null && curUser.getLowerName().equals(gvUserName)) continue;
                curUser = OfBizUser.from(gv);
                userProcessor.accept((com.atlassian.crowd.model.user.User)curUser);
            } while (gv != null);
        }
    }

    @Override
    public boolean isDeletedExternally(long internalUserId) {
        GenericValue user = this.getUserByInternalId(internalUserId);
        if (user == null) {
            return false;
        }
        return this.userDeletedExternally(user);
    }

    @Override
    public boolean isDeletedExternally(long directoryId, @Nonnull String userName) {
        OfBizUser user = this.findByNameOrNull(directoryId, userName);
        if (user == null) {
            return false;
        }
        return user.isDeletedExternally();
    }

    @Nullable
    private GenericValue getUserByInternalId(long internalUserId) {
        return (GenericValue)Select.columns(OfBizUser.SUPPORTED_FIELDS).from("User").whereEqual("id", internalUserId).runWith(this.ofBizDelegator).singleValue();
    }

    @Override
    public void flushCache() {
        this.userCaseInsensitiveCache.refresh();
        this.userAttributesCache.removeAll();
    }

    @Nonnull
    private GenericValue findUserGenericValue(long directoryId, String userName) throws UserNotFoundException {
        GenericValue userGenericValue = (GenericValue)Select.from("User").whereEqual("directoryId", directoryId).andEqual("lowerUserName", IdentifierUtils.toLowerCase((String)userName)).runWith(this.ofBizDelegator).singleValue();
        if (userGenericValue == null) {
            throw new UserNotFoundException(userName);
        }
        return userGenericValue;
    }

    @Nonnull
    private Long findUserId(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        Long id = (Long)Select.id().from("User").whereEqual("directoryId", user.getDirectoryId()).andEqual("lowerUserName", OfBizUserDao.getLowerUserName(user)).runWith(this.ofBizDelegator).singleValue();
        if (id == null) {
            throw new UserNotFoundException(user.getName());
        }
        return id;
    }

    private boolean userExists(String name, long directoryId) {
        return this.findByNameOrNull(directoryId, name) != null;
    }

    private static String getLowerUserName(com.atlassian.crowd.model.user.User user) {
        if (user instanceof OfBizUser) {
            return ((OfBizUser)user).getLowerName();
        }
        return IdentifierUtils.toLowerCase((String)user.getName());
    }

    private static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private /* synthetic */ void lambda$search$5(EntityFindOptions findOptions, EntityCondition entityCondition, List fieldsToSelect, List sortFields, List results, OfBizTransaction t) {
        this.configureDatabaseStreaming(findOptions);
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("User", entityCondition, null, (Collection)fieldsToSelect, sortFields, findOptions);){
            for (GenericValue genericValue : iterator) {
                results.add(genericValue);
            }
        }
    }

    class SetAttributeForAllInDirectoryOperation {
        private final Long directoryId;
        private final String attrName;
        private final String attrValue;
        private final String lowerAttrValue;
        private Set<Long> userIds = new HashSet<Long>(16384);
        private Set<Long> errors = new HashSet<Long>(64);
        private int updated = 0;
        private int created = 0;

        SetAttributeForAllInDirectoryOperation(long directoryId, String attrName, String attrValue) {
            this.directoryId = directoryId;
            this.attrName = attrName;
            this.attrValue = attrValue;
            this.lowerAttrValue = IdentifierUtils.toLowerCase((String)attrValue);
        }

        private void updateExisting() {
            this.updated = Update.into("UserAttribute").set("value", this.attrValue).set("lowerValue", this.lowerAttrValue).whereEqual("directoryId", this.directoryId).andEqual("name", this.attrName).execute(OfBizUserDao.this.ofBizDelegator);
        }

        private void collectAllUserIdsInDirectory() {
            Select.id().from("User").whereEqual("directoryId", this.directoryId).runWith(OfBizUserDao.this.ofBizDelegator).visitWith(new Visitor<Long>(){

                public void visit(Long userId) {
                    SetAttributeForAllInDirectoryOperation.this.userIds.add(userId);
                }
            });
        }

        private void discardUserIdsWithMatchingAttribute() {
            Select.columns("userId").from("UserAttribute").whereEqual("directoryId", this.directoryId).andEqual("name", this.attrName).runWith(OfBizUserDao.this.ofBizDelegator).visitWith(new Visitor<GenericValue>(){

                public void visit(GenericValue userIdHolder) {
                    SetAttributeForAllInDirectoryOperation.this.userIds.remove(userIdHolder.getLong("userId"));
                }
            });
        }

        private void createAttributeForRemainingUserIds() {
            for (Long userId : this.userIds) {
                this.createAttribute(userId);
            }
        }

        private void createAttribute(Long userId) {
            try {
                OfBizUserDao.this.ofBizDelegator.createValue("UserAttribute", (Map)new FieldMap().add("directoryId", (Object)this.directoryId).add("userId", (Object)userId).add("name", (Object)this.attrName).add("value", (Object)this.attrValue).add("lowerValue", (Object)this.lowerAttrValue));
                ++this.created;
            }
            catch (DataAccessException dae) {
                this.errors.add(userId);
                log.debug("Failed to create attribute", (Throwable)dae);
            }
        }

        void perform() {
            this.updateExisting();
            this.collectAllUserIdsInDirectory();
            this.discardUserIdsWithMatchingAttribute();
            this.createAttributeForRemainingUserIds();
            if (!this.errors.isEmpty()) {
                log.warn("setAttributeForAllInDirectory({}, \"{}\", \"{}\"): created={}; updated={}; errors={}", new Object[]{this.directoryId, this.attrName, this.attrValue, this.created, this.updated, this.errors});
            } else if (log.isDebugEnabled()) {
                log.debug("setAttributeForAllInDirectory({}, \"{}\", \"{}\"): created={}; updated={}", new Object[]{this.directoryId, this.attrName, this.attrValue, this.created, this.updated});
            }
        }
    }

    private class UserAttributesCacheLoader
    implements CacheLoader<AttributeKey, Attributes> {
        private UserAttributesCacheLoader() {
        }

        @Nonnull
        public Attributes load(@Nonnull AttributeKey key) {
            List<GenericValue> attributes = Select.columns(OfBizAttributesBuilder.SUPPORTED_FIELDS).from("UserAttribute").whereEqual("directoryId", key.getDirectoryId()).andEqual("userId", key.getUserId()).runWith(OfBizUserDao.this.ofBizDelegator).asList();
            return OfBizAttributesBuilder.toAttributes(attributes);
        }
    }
}

