/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.Cache;
import com.atlassian.jira.cluster.cache.pauser.ClusteredReplicationPauserManager;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.util.Visitor;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UserOrGroupCache<T extends UserOrGroupStub> {
    private static final Logger LOG = LoggerFactory.getLogger(UserOrGroupCache.class);
    private final String entityName;
    private final ResettableLazyReference<Cache<DirectoryEntityKey, T>> cacheRef;

    UserOrGroupCache(String entityName) {
        this.entityName = entityName;
        this.cacheRef = new ResettableLazyReference<Cache<DirectoryEntityKey, T>>(){

            protected Cache<DirectoryEntityKey, T> create() {
                Cache cache = UserOrGroupCache.this.createCache();
                UserOrGroupCache.this.buildCacheFromDatabaseWithoutCacheReplication(cache);
                return cache;
            }
        };
    }

    Cache<DirectoryEntityKey, T> getCache() {
        try {
            return (Cache)this.cacheRef.get();
        }
        catch (LazyReference.InitializationException ex) {
            this.cacheRef.reset();
            throw ex;
        }
    }

    public void refresh() {
        this.cacheRef.reset();
        this.getCache();
    }

    @Nullable
    public T getCaseInsensitive(long directoryId, String name) {
        DirectoryEntityKey key1;
        Cache<DirectoryEntityKey, T> cache = this.getCache();
        UserOrGroupStub result = (UserOrGroupStub)cache.get((Object)(key1 = DirectoryEntityKey.getKeyPreserveCase(directoryId, name)));
        if (result != null) {
            return (T)result;
        }
        DirectoryEntityKey key2 = DirectoryEntityKey.getKeyLowerCase(directoryId, name);
        return (T)(key1.getName() != key2.getName() ? (UserOrGroupStub)cache.get((Object)key2) : null);
    }

    @Nullable
    public T getCaseSensitive(long directoryId, String name) {
        return (T)((UserOrGroupStub)this.getCache().get((Object)DirectoryEntityKey.getKeyPreserveCase(directoryId, name)));
    }

    public Collection<DirectoryEntityKey> getKeys() {
        return this.getCache().getKeys();
    }

    public DirectoryEntityKey refresh(T value) {
        DirectoryEntityKey key = DirectoryEntityKey.getKeyFor(value);
        this.getCache().put((Object)key, value);
        return key;
    }

    public void remove(long directoryId, String name) {
        this.remove(DirectoryEntityKey.getKeyLowerCase(directoryId, name));
    }

    public void remove(DirectoryEntityKey key) {
        this.getCache().remove((Object)key);
    }

    public void removeAll() {
        this.getCache().removeAll();
    }

    private void buildCacheFromDatabaseWithoutCacheReplication(Cache<DirectoryEntityKey, T> cache) {
        new ClusteredReplicationPauserManager().pauseReplicationFor(() -> {
            cache.removeAll();
            Tracker tracker = new Tracker(new PutVisitor(cache));
            this.visitAllUsingDatabase(tracker);
            tracker.close();
        }, "Loading" + this.entityName + "cache");
    }

    abstract Cache<DirectoryEntityKey, T> createCache();

    abstract long countAllUsingDatabase();

    public abstract void visitAllUsingDatabase(Visitor<T> var1);

    class Tracker
    implements Visitor<T> {
        static final int PROGRESS_REPORTING_INTERVAL = 10000;
        final AtomicInteger numProcessed = new AtomicInteger();
        final Instant start;
        final Visitor<T> delegate;

        Tracker(Visitor<T> delegate) {
            this.delegate = delegate;
            this.start = Instant.now();
            LOG.info("Refreshing {} cache from the database", (Object)UserOrGroupCache.this.entityName);
        }

        void close() {
            Instant end = Instant.now();
            Duration duration = Duration.between(this.start, end);
            LOG.info("Completed refreshing {} cache in {}", (Object)UserOrGroupCache.this.entityName, (Object)duration);
        }

        public void visit(T element) {
            this.delegate.visit(element);
            this.numProcessed.incrementAndGet();
            if (this.numProcessed.get() % 10000 == 0 && this.numProcessed.get() > 0) {
                LOG.info("refreshing {} cache from database, loaded {} {}s", new Object[]{UserOrGroupCache.this.entityName, this.numProcessed, UserOrGroupCache.this.entityName});
            }
        }
    }

    class PutVisitor
    implements Visitor<T> {
        private final Cache<DirectoryEntityKey, T> cache;

        PutVisitor(Cache<DirectoryEntityKey, T> cache) {
            this.cache = cache;
        }

        public void visit(T value) {
            this.cache.put((Object)DirectoryEntityKey.getKeyFor(value), value);
        }
    }
}

