/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard.permission;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JiraPermissionService
implements DashboardPermissionService {
    private final UserManager userManager;
    private final PortalPageService portalPageService;
    private final PermissionManager permissionManager;
    @VisibleForTesting
    static final Boolean INITIAL_ALLOW_EDITING_OF_DEFAULT_DASHBOARD = Boolean.TRUE;
    private static final ThreadLocal<Boolean> allowEditingOfDefaultDashboard = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return INITIAL_ALLOW_EDITING_OF_DEFAULT_DASHBOARD;
        }
    };

    public JiraPermissionService(UserManager userManager, PortalPageService portalPageService, PermissionManager permissionManager) {
        this.userManager = userManager;
        this.portalPageService = portalPageService;
        this.permissionManager = permissionManager;
    }

    public boolean isReadableBy(DashboardId dashboardId, @Nullable ApplicationUser user) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        return this.portalPageService.validateForGetPortalPage((JiraServiceContext)context, Long.valueOf(dashboardId.value()));
    }

    public boolean isReadableBy(DashboardId dashboardId, @Nullable String username) {
        return this.isReadableBy(dashboardId, this.getUser(username));
    }

    public boolean isWritableBy(DashboardId dashboardId, @Nullable ApplicationUser user) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        PortalPage portalPage = this.portalPageService.getPortalPage((JiraServiceContext)context, Long.valueOf(dashboardId.value()));
        if (portalPage == null) {
            return false;
        }
        if (!portalPage.isSystemDefaultPortalPage()) {
            return this.portalPageService.validateForUpdate((JiraServiceContext)context, portalPage);
        }
        return allowEditingOfDefaultDashboard.get() != false && this.portalPageService.validateForUpdate((JiraServiceContext)context, portalPage);
    }

    public boolean isWritableBy(DashboardId dashboardId, @Nullable String username) {
        return this.isWritableBy(dashboardId, this.getUser(username));
    }

    public static void setAllowEditingOfDefaultDashboard(boolean allow) {
        allowEditingOfDefaultDashboard.set(allow);
    }

    private ApplicationUser getUser(String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return null;
        }
        return this.userManager.getUserByName(username);
    }
}

