/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.DatabaseVendor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;

public class QueryDslUtils {
    public static StringTemplate oracleCastClobToNvarchar(StringPath column) {
        return Expressions.stringTemplate((String)"dbms_lob.substr({0}, 4000, 1)", (Object[])new Object[]{column});
    }

    public static StringTemplate mssqlCastNTextToNvarchar(StringPath column) {
        return Expressions.stringTemplate((String)"cast({0} as nvarchar(max))", (Object[])new Object[]{column});
    }

    public static BooleanExpression safeContainsIgnoreCase(DatabaseVendor vendor, StringPath column, String str) {
        return QueryDslUtils.ensureCorrectDataType(vendor, column).containsIgnoreCase(str);
    }

    private static StringExpression ensureCorrectDataType(DatabaseVendor vendor, StringPath column) {
        if (DatabaseVendor.SQL_SERVER.equals((Object)vendor)) {
            return QueryDslUtils.mssqlCastNTextToNvarchar(column);
        }
        return column;
    }
}

