/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database.measure;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.database.measure.DatabaseQueryMeter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class ClockBasedDatabaseQueryMeter
implements DatabaseQueryMeter {
    private static final String TIMEOUT_PROPERTY = "com.atlassian.jira.database.query.meter.timeout";
    private final Clock clock;
    private final int timeout;

    public ClockBasedDatabaseQueryMeter(Clock clock, JiraProperties jiraProperties) {
        this.clock = clock;
        this.timeout = jiraProperties.getInteger(TIMEOUT_PROPERTY, Integer.valueOf(10));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Duration measure(Connection connection, String query) {
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setQueryTimeout(this.timeout);
            Instant startTime = this.clock.instant();
            ResultSet resultSet = statement.executeQuery();
            resultSet.close();
            Instant endTime = this.clock.instant();
            Duration duration = Duration.between(startTime, endTime);
            return duration;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while measuring database query " + query, ex);
        }
    }
}

