/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

class DateTimeRFC1123DateTimeFormatter
implements DateTimeFormatStrategy {
    private final JodaFormatterSupplier cache;
    public static String RFC_1123_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public DateTimeRFC1123DateTimeFormatter(JodaFormatterSupplier cache) {
        this.cache = cache;
    }

    @Override
    public String format(DateTime dateTime, Locale locale) {
        DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(RFC_1123_FORMAT, Locale.US));
        return formatter.print((ReadableInstant)dateTime);
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) throws UnsupportedOperationException {
        DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(RFC_1123_FORMAT, Locale.US)).withZone(timeZone);
        return formatter.parseDateTime(text).toDate();
    }

    @Override
    public DateTimeStyle style() {
        return DateTimeStyle.RFC_1123_DATE_TIME;
    }

    @Override
    public String pattern() {
        return RFC_1123_FORMAT;
    }
}

