/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic.connection;

import com.atlassian.jira.diagnostic.connection.DatabaseDiagnosticsCollectorDelegate;
import com.atlassian.jira.diagnostic.connection.DiagnosticCallableStatement;
import com.atlassian.jira.diagnostic.connection.DiagnosticPreparedStatement;
import com.atlassian.jira.diagnostic.connection.DiagnosticStatement;
import com.atlassian.jira.ofbiz.sql.ConnectionWrapper;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class DiagnosticConnection
extends ConnectionWrapper {
    private final DatabaseDiagnosticsCollectorDelegate databaseDiagnosticsCollector;

    public DiagnosticConnection(Connection wrappedConnection, DatabaseDiagnosticsCollectorDelegate databaseDiagnosticsCollector) {
        super(wrappedConnection);
        this.databaseDiagnosticsCollector = databaseDiagnosticsCollector;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DiagnosticStatement(super.createStatement(), this.databaseDiagnosticsCollector);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticStatement(super.createStatement(resultSetType, resultSetConcurrency), this.databaseDiagnosticsCollector);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.databaseDiagnosticsCollector);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DiagnosticPreparedStatement(super.prepareStatement(sql), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DiagnosticPreparedStatement(super.prepareStatement(sql, autoGeneratedKeys), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DiagnosticPreparedStatement(super.prepareStatement(sql, columnIndexes), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DiagnosticPreparedStatement(super.prepareStatement(sql, columnNames), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new DiagnosticCallableStatement(super.prepareCall(sql), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticCallableStatement(super.prepareCall(sql, resultSetType, resultSetConcurrency), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticCallableStatement(super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.databaseDiagnosticsCollector, sql);
    }

    @Override
    public void close() throws SQLException {
        this.databaseDiagnosticsCollector.removeTrackedConnection(this);
        super.close();
    }
}

