/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic.connection;

import com.atlassian.jira.diagnostic.connection.DatabaseDiagnosticsCollectorDelegate;
import com.atlassian.jira.ofbiz.sql.PreparedStatementWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DiagnosticPreparedStatement
extends PreparedStatementWrapper {
    private final DatabaseDiagnosticsCollectorDelegate databaseDiagnosticsCollector;
    private final List<String> batchQueries;
    private final String sql;

    DiagnosticPreparedStatement(PreparedStatement wrappedStatement, DatabaseDiagnosticsCollectorDelegate databaseDiagnosticsCollector, String sql) {
        super(wrappedStatement);
        this.databaseDiagnosticsCollector = databaseDiagnosticsCollector;
        this.batchQueries = new ArrayList<String>();
        this.sql = sql;
    }

    @Override
    public boolean execute() throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(), this.sql);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql), sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql, autoGeneratedKeys), sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql, columnIndexes), sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql, columnNames), sql);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return (ResultSet)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeQuery(), this.sql);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return (ResultSet)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeQuery(sql), sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(), this.sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql, columnIndexes), sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql, columnNames), sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql), sql);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql), sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql, columnIndexes), sql);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql, columnNames), sql);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(), this.sql);
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch();
        if (this.batchQueries.isEmpty()) {
            this.batchQueries.add(this.sql);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        super.addBatch(sql);
        if (this.batchQueries.size() < 10) {
            this.batchQueries.add(sql);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchQueries.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] updateCounts = (int[])this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeBatch(), this.getBatchQueries());
        this.batchQueries.clear();
        return updateCounts;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        long[] updateCounts = (long[])this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeBatch(), this.getBatchQueries());
        this.batchQueries.clear();
        return updateCounts;
    }

    private String getBatchQueries() {
        return String.join((CharSequence)",\n ", this.batchQueries);
    }
}

