/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.operation;

import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationHolder;
import java.util.Objects;

public class SpanningOperationHolderImpl
implements SpanningOperationHolder {
    private static ThreadLocal<SpanningOperation> context = new ThreadLocal();

    @Override
    public SpanningOperation get() {
        return context.get();
    }

    @Override
    public void set(SpanningOperation spanningOperation) {
        context.set(spanningOperation);
    }

    @Override
    public void clear() {
        context.remove();
    }

    @Override
    public SpanningOperation pop() {
        SpanningOperation existingSpanningOperation = context.get();
        if (existingSpanningOperation == null) {
            return null;
        }
        if (existingSpanningOperation.getParent() != null) {
            context.set(existingSpanningOperation.getParent());
            return existingSpanningOperation;
        }
        context.remove();
        return existingSpanningOperation;
    }

    @Override
    public SpanningOperation push(SpanningOperation spanningOperation) {
        Objects.requireNonNull(spanningOperation);
        SpanningOperation existingSpanningOperation = context.get();
        if (existingSpanningOperation != null) {
            context.set(SpanningOperation.builder().parent(existingSpanningOperation).type(spanningOperation.getType()).id(spanningOperation.getId()).build());
        } else {
            context.set(spanningOperation);
        }
        return context.get();
    }

    public static void clearContext() {
        context.remove();
    }
}

