/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.FileStoreConfigType;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.filestore.FileStoreSwitcher;
import com.atlassian.jira.filestore.FileSystemAttachmentFileStoreProvider;
import com.atlassian.jira.filestore.NoOpAttachmentFileStoreProvider;
import com.atlassian.jira.filestore.S3AttachmentFileStoreProvider;
import com.atlassian.jira.license.DataCenterOrDevModeCheck;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.Objects;

public class AttachmentFileStoreSwitcher
extends FileStoreSwitcher<AttachmentFileStoreProvider> {
    private final FeatureManager featureManager;

    public AttachmentFileStoreSwitcher(JiraProperties jiraSystemProperties, DataCenterOrDevModeCheck dataCenterOrDevModeCheck, FileStoresConfigurationLoader fileStoresConfigurationLoader, FeatureManager featureManager) {
        super(jiraSystemProperties, dataCenterOrDevModeCheck, fileStoresConfigurationLoader, FileStoreAssociationTarget.ATTACHMENTS, FileSystemAttachmentFileStoreProvider.class, Collections.singletonMap(FileStoreConfigType.S3, S3AttachmentFileStoreProvider.class), NoOpAttachmentFileStoreProvider.class);
        this.featureManager = Objects.requireNonNull(featureManager);
    }

    @Override
    protected Either<String, Unit> canUseAlternateFileStore() {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ATTACHMENTS_STORAGE_CONFIGURABLE.featureKey())) {
            return super.canUseAlternateFileStore();
        }
        return Either.left((Object)String.format("Due to the feature %s being disabled, the attachments storage is not configurable", JiraFeatureFlagRegistrar.ATTACHMENTS_STORAGE_CONFIGURABLE.featureKey()));
    }
}

