/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import java.util.Objects;
import javax.annotation.Nonnull;

public class FileStoreAnalyticInfo {
    private final String fileStoreType;
    private final boolean isS3EndpointOverrideUsed;

    private FileStoreAnalyticInfo(@Nonnull String fileStoreType, boolean isS3EndpointOverrideUsed) {
        this.fileStoreType = fileStoreType;
        this.isS3EndpointOverrideUsed = isS3EndpointOverrideUsed;
    }

    public static FileStoreAnalyticInfo s3AnalyticInfo(boolean isS3EndpointOverrideUsed) {
        return new FileStoreAnalyticInfo("S3", isS3EndpointOverrideUsed);
    }

    public static FileStoreAnalyticInfo fileSystemAnalyticInfo() {
        return new FileStoreAnalyticInfo("FILE_SYSTEM", false);
    }

    public static FileStoreAnalyticInfo noOpAnalyticInfo() {
        return new FileStoreAnalyticInfo("NO_OP", false);
    }

    @Nonnull
    public String getFileStoreType() {
        return this.fileStoreType;
    }

    public boolean isS3EndpointOverrideUsed() {
        return this.isS3EndpointOverrideUsed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileStoreAnalyticInfo otherAnalytic = (FileStoreAnalyticInfo)other;
        return this.isS3EndpointOverrideUsed == otherAnalytic.isS3EndpointOverrideUsed && Objects.equals(this.fileStoreType, otherAnalytic.fileStoreType);
    }

    public int hashCode() {
        return Objects.hash(this.fileStoreType, this.isS3EndpointOverrideUsed);
    }
}

