/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class FileStoreInformation {
    private final String headingKey;
    private final List<Entry> entries = new ArrayList<Entry>();

    private FileStoreInformation(String headingKey, Collection<Entry> entries) {
        this.headingKey = headingKey;
        if (entries != null) {
            this.entries.addAll(entries);
        }
    }

    public Internationalized getInternationalizedView(I18nHelper i18nHelper) {
        List localisedEntries = this.entries.stream().map(entry -> entry.getText(i18nHelper)).collect(Collectors.toList());
        return new Internationalized(i18nHelper.getText(this.headingKey), localisedEntries);
    }

    public static class Internationalized {
        private final String heading;
        private final List<String> entries = new ArrayList<String>();

        private Internationalized(String heading, Collection<String> entries) {
            this.heading = heading;
            if (entries != null) {
                this.entries.addAll(entries);
            }
        }

        public String getHeading() {
            return this.heading;
        }

        public List<String> getEntries() {
            return this.entries;
        }
    }

    private static final class InternationalisedEntry
    implements Entry {
        private final String i18nKey;
        private final List<String> templateParams = new ArrayList<String>();

        private InternationalisedEntry(String i18nKey, Collection<String> templateParams) {
            this.i18nKey = i18nKey;
            if (templateParams != null) {
                this.templateParams.addAll(templateParams);
            }
        }

        @Override
        public String getText(I18nHelper i18nHelper) {
            return i18nHelper.getText(this.i18nKey, (Object)this.templateParams.toArray(new String[0]));
        }
    }

    private static final class StringEntry
    implements Entry {
        private final String value;

        private StringEntry(String value) {
            this.value = value;
        }

        @Override
        public String getText(I18nHelper i18nHelper) {
            return this.value;
        }
    }

    public static interface Entry {
        public String getText(I18nHelper var1);
    }

    public static final class Builder {
        private String headingKey = null;
        private final List<Entry> entries = new ArrayList<Entry>();

        public Builder setHeadingKey(String headingKey) {
            this.headingKey = headingKey;
            return this;
        }

        public Builder addI18nEntry(String i18nKey, List<String> templateParams) {
            this.entries.add(new InternationalisedEntry(i18nKey, templateParams));
            return this;
        }

        public Builder addStringEntry(String information) {
            this.entries.add(new StringEntry(information));
            return this;
        }

        public FileStoreInformation build() {
            return new FileStoreInformation(this.headingKey, this.entries);
        }
    }
}

