/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.appconsistency.FakeHealthCheck;
import com.atlassian.jira.cluster.health.NodeIdHealthCheck;
import com.atlassian.jira.cluster.health.SharedHomeHealthCheck;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckRegistry;
import com.atlassian.jira.health.checks.CustomisedConfigurationsHealthCheck;
import com.atlassian.jira.health.checks.DbConfigurationAndConnectionCheck;
import com.atlassian.jira.health.checks.FileStoreConfigurationHealthCheck;
import com.atlassian.jira.health.checks.FileStoreConnectionHealthCheck;
import com.atlassian.jira.health.checks.JiraHomeHealthCheck;
import com.atlassian.jira.health.checks.MinMemoryHealthCheck;
import com.atlassian.jira.health.checks.ProhibitedServerLicenseHealthCheck;
import com.atlassian.jira.health.checks.TomcatConfigurationHealthCheck;
import com.atlassian.jira.health.checks.database.BuildVersionCheck;
import com.atlassian.jira.health.checks.database.CollationHealthCheck;
import com.atlassian.jira.health.checks.database.DatabaseSecretStoreRetrievalHealthCheck;
import com.atlassian.jira.health.checks.database.JdbcDriverHealthCheck;
import com.atlassian.jira.health.checks.database.MSSQLDriverMigrationHealthCheck;
import com.atlassian.jira.health.checks.database.MinimumUpgradableVersionHealthCheck;
import com.atlassian.jira.health.checks.database.MySql8ModeHealthCheck;
import com.atlassian.jira.health.checks.database.MySqlJdbcUrlHealthCheck;
import com.atlassian.jira.health.checks.database.PostgresSchemaHealthCheck;
import com.atlassian.jira.health.checks.database.PublicSchemaHealthCheck;
import com.atlassian.jira.health.checks.database.SupportedDatabaseVersionHealthCheck;
import com.atlassian.jira.health.checks.database.UnsupportedHsqlHealthCheck;
import com.atlassian.jira.startup.SystemPluginsEnabledHealthCheck;
import javax.annotation.Nonnull;

public final class HealthCheckRegistrar {
    public static void registerHealthChecks(@Nonnull HealthCheckRegistry registry) {
        registry.register(new FakeHealthCheck());
        registry.register(new MinMemoryHealthCheck(new HealthCheck[0]));
        registry.register(new JiraHomeHealthCheck(new HealthCheck[0]));
        registry.register(new CustomisedConfigurationsHealthCheck(new HealthCheck[0]));
        registry.register(new SupportedDatabaseVersionHealthCheck(new HealthCheck[0]));
        MSSQLDriverMigrationHealthCheck mssqlDriverMigrationHealthCheck = new MSSQLDriverMigrationHealthCheck(new HealthCheck[0]);
        registry.register(mssqlDriverMigrationHealthCheck);
        registry.register(new DatabaseSecretStoreRetrievalHealthCheck(new HealthCheck[0]));
        registry.register(new JdbcDriverHealthCheck(mssqlDriverMigrationHealthCheck));
        registry.register(new UnsupportedHsqlHealthCheck(new HealthCheck[0]));
        registry.register(new MySqlJdbcUrlHealthCheck(new HealthCheck[0]));
        registry.register(MySql8ModeHealthCheck.createInstance(new HealthCheck[0]));
        registry.register(new PublicSchemaHealthCheck(new HealthCheck[0]));
        registry.register(new PostgresSchemaHealthCheck(new HealthCheck[0]));
        registry.register(new DbConfigurationAndConnectionCheck(new HealthCheck[0]));
        registry.register(new CollationHealthCheck(new HealthCheck[0]));
        registry.register(new BuildVersionCheck(new HealthCheck[0]));
        registry.register(new MinimumUpgradableVersionHealthCheck(new HealthCheck[0]));
        registry.register(new SystemPluginsEnabledHealthCheck(new HealthCheck[0]));
        registry.register(new TomcatConfigurationHealthCheck(new HealthCheck[0]));
        registry.register(NodeIdHealthCheck.getInstance(new HealthCheck[0]));
        registry.register(SharedHomeHealthCheck.getInstance(new HealthCheck[0]));
        registry.register(new FileStoreConfigurationHealthCheck(new HealthCheck[0]));
        registry.register(new FileStoreConnectionHealthCheck(new HealthCheck[0]));
        registry.register(new ProhibitedServerLicenseHealthCheck(new HealthCheck[0]));
        registry.registrationComplete();
    }

    private HealthCheckRegistrar() {
    }
}

