/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public abstract class MySQLHealthCheckTemplate
extends HealthCheckTemplate {
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/sIkjN");
    private static final Logger log = LoggerFactory.getLogger(MySQLHealthCheckTemplate.class);
    protected final DatabaseConfigurationManager manager;

    protected MySQLHealthCheckTemplate(Iterable<HealthCheck> prerequisites, DatabaseConfigurationManager databaseConfigurationManager) {
        super(prerequisites);
        this.manager = databaseConfigurationManager;
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.DATABASE_CONFIGURED));
    }

    @Override
    public List<HealthCheckResult> doPerform() {
        return Optional.ofNullable(this.manager).filter(this::isApplicableDatabaseType).map(this::verify).orElse(Collections.emptyList());
    }

    public boolean isApplicableDatabaseType(DatabaseConfigurationManager configurationManager) {
        return this.getDatabaseType().getTypeName().equals(configurationManager.getDatabaseConfiguration().getDatabaseType());
    }

    protected abstract DatabaseType getDatabaseType();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<HealthCheckResult> verify(DatabaseConfigurationManager configurationManager) {
        try (Connection conn = configurationManager.getDatabaseConfiguration().getDatasource().getConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());){
            boolean versionCorrect = this.getVersionPredicate().test(conn);
            boolean configurationProper = this.getConfigurationCheckerPredicate().test(conn);
            if (!versionCorrect) {
                List<HealthCheckResult> list = this.createHealthCheckResult(this.createErrorMessage());
                return list;
            }
            if (configurationProper) return Collections.emptyList();
            List<HealthCheckResult> list = this.createHealthCheckResult(this.createServerConfigErrorMessage());
            return list;
        }
        catch (BootstrapException | SQLException ex) {
            log.error("There is database configuration error!", ex);
            return this.createHealthCheckResult(this.createErrorMessage());
        }
    }

    protected abstract Predicate<Connection> getVersionPredicate();

    protected abstract Predicate<Connection> getConfigurationCheckerPredicate();

    protected List<HealthCheckResult> createHealthCheckResult(HealthCheckMessageFormatter messageFormatter) {
        return HealthCheckResult.fail(this, new Event(JohnsonEventType.DATABASE.eventType(), "We've found an error in MySQL supported version!", messageFormatter.toHtml(), EventLevels.fatal()), KB_URL, "mysql-version-incompatibility", messageFormatter.toText());
    }

    protected HealthCheckMessageFormatter createErrorMessage() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("The database type in your "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("dbconfig.xml")), HealthCheckMessageFormatter.string(String.format(" is set up to %s and your MySQL version is different. Consider using %s database type instead", this.getDatabaseType().getDisplayName(), this.getDatabaseType().getDisplayName())).addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on changing database type.")));
        return messageFormatter;
    }

    protected HealthCheckMessageFormatter createServerConfigErrorMessage() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("The database setup is not supporting utf8mb4")).addLineBreak().append(HealthCheckMessageFormatter.string(String.format("See our documentation for more information on setting up %s", this.getDatabaseType().getDisplayName())));
        return messageFormatter;
    }
}

