/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.health.ModificationMigrationLocationService;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PreviousVersionHashService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviousVersionHashService.class);
    private final ModificationMigrationLocationService locationService;

    public static PreviousVersionHashService getInstance() {
        return new PreviousVersionHashService(ModificationMigrationLocationService.getInstance());
    }

    public PreviousVersionHashService(ModificationMigrationLocationService locationService) {
        this.locationService = Objects.requireNonNull(locationService);
    }

    public <T> T withHashProvider(Function<HashProvider, T> f) {
        Map<String, String> hashes = this.initHashes();
        return f.apply(path -> Optional.ofNullable(hashes.get(path.toString())));
    }

    private Map<String, String> initHashes() {
        try {
            return this.readHashFile(this.locationService.getCustomisationsDirectory().resolve("baseline-hash-registry.properties"));
        }
        catch (IOException e) {
            LOGGER.info("Cannot read baseline-hash-registry.properties", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<String, String> readHashFile(Path baselineHashFilePath) throws IOException {
        try (LineIterator it = FileUtils.lineIterator((File)baselineHashFilePath.toFile());){
            Map<String, String> map = Streams.stream((Iterator)it).map(line -> line.trim().split("=")).filter(arr -> ((String[])arr).length == 2).collect(Collectors.toMap(line -> line[0], line -> line[1]));
            return map;
        }
    }

    public static interface HashProvider {
        public Optional<String> getHash(Path var1);
    }
}

