/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.analytics;

import com.atlassian.jira.health.FileCopyService;
import com.atlassian.jira.health.analytics.AbstractHeliumFilesEvent;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class HeliumCopyFilesAnalyticsEvent
extends AbstractHeliumFilesEvent {
    private final int successFilesCount;
    private final int failedFilesCount;
    private final Collection<FileCopyService.CopyFailure> uncopiedFiles;

    public HeliumCopyFilesAnalyticsEvent(int autoCopyFilesCopyCount, int manualCopyFilesCount, int successFilesCount, int failedFilesCount, Collection<FileCopyService.CopyFailure> uncopiedFiles) {
        super("copyfiles", autoCopyFilesCopyCount, manualCopyFilesCount);
        this.successFilesCount = successFilesCount;
        this.failedFilesCount = failedFilesCount;
        this.uncopiedFiles = uncopiedFiles;
    }

    public int getSuccessFilesCount() {
        return this.successFilesCount;
    }

    public int getFailedFilesCount() {
        return this.failedFilesCount;
    }

    public Collection<Map<String, String>> getCopyingErrors() {
        return this.uncopiedFiles.stream().map(e -> ImmutableMap.of((Object)"exceptionClass", (Object)HeliumCopyFilesAnalyticsEvent.toUUID(e.getException().getClass().getName()), (Object)"relativeFilePath", (Object)HeliumCopyFilesAnalyticsEvent.toUUID(e.getRelativeFilePath().toString()), (Object)"error", (Object)e.getError().name())).collect(Collectors.toList());
    }

    private static String toUUID(String s) {
        return UUID.nameUUIDFromBytes(s.getBytes()).toString();
    }
}

