/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.filestore.FileStoreConnectionCheck;
import com.atlassian.jira.filestore.FileStoreConnectionFailure;
import com.atlassian.jira.filestore.FileStoreProvider;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.license.DataCenterOrDevModeCheck;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class FileStoreConnectionHealthCheck
extends HealthCheckTemplate {
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/display/ADMINJIRASERVER/Configuring+Amazon+S3+Object+Storage");
    private final Supplier<List<Pair<String, FileStoreConnectionCheck>>> connectionChecks;
    private String errorReason;
    private final List<String> failedFeatures = new ArrayList<String>();

    public FileStoreConnectionHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        ClusterInfo clusterInfo = (ClusterInfo)ComponentAccessor.getComponent(ClusterInfo.class);
        this.connectionChecks = () -> Arrays.asList(new Pair((Object)"avatar", (Object)new FileStoreConnectionCheck((FileStoreProvider)ComponentAccessor.getComponent(AvatarFileStoreProvider.class), clusterInfo)), new Pair((Object)"attachment", (Object)new FileStoreConnectionCheck((FileStoreProvider)ComponentAccessor.getComponent(AttachmentFileStoreProvider.class), clusterInfo)));
    }

    @VisibleForTesting
    FileStoreConnectionHealthCheck(Supplier<List<Pair<String, FileStoreConnectionCheck>>> connectionChecks, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.connectionChecks = Objects.requireNonNull(connectionChecks);
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_DATABASE_ACTIVATED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        if (!((DataCenterOrDevModeCheck)ComponentAccessor.getComponent(DataCenterOrDevModeCheck.class)).isDataCenterOrDevMode()) {
            return Collections.emptyList();
        }
        if (!this.canConnectToFileStore()) {
            String description = "Unable to connect to the " + this.getFailedFeatures() + " storage.";
            String errorMessage = this.errorReason;
            Event event = new Event(JohnsonEventType.SETUP.eventType(), description, errorMessage, JohnsonEventLevel.WARNING.eventLevel());
            event.addAttribute((Object)"dismissible", (Object)true);
            return HealthCheckResult.fail(this, event, KB_URL, "bootstrap-exception", errorMessage);
        }
        return Collections.emptyList();
    }

    private boolean canConnectToFileStore() {
        ArrayList failedChecks = new ArrayList();
        ((List)this.connectionChecks.get()).forEach(c -> {
            Either<FileStoreConnectionFailure, FileStore.Path> connectionResult = ((FileStoreConnectionCheck)c.right()).check();
            if (connectionResult.left().isDefined()) {
                failedChecks.add(connectionResult.left().get());
                this.failedFeatures.add((String)c.left());
            }
        });
        if (!failedChecks.isEmpty()) {
            this.errorReason = ((FileStoreConnectionFailure)failedChecks.get(0)).getErrorDetails();
            return false;
        }
        return true;
    }

    private String getFailedFeatures() {
        if (this.failedFeatures.size() == 1) {
            return this.failedFeatures.get(0);
        }
        StringBuilder result = new StringBuilder();
        this.failedFeatures.forEach(f -> {
            if (f.equals(this.failedFeatures.get(this.failedFeatures.size() - 1))) {
                result.append("and ").append((String)f);
            } else if (f.equals(this.failedFeatures.get(this.failedFeatures.size() - 2))) {
                result.append((String)f).append(" ");
            } else {
                result.append((String)f).append(",");
            }
        });
        return result.toString();
    }
}

