/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.ImmutableHelpUrl;
import com.atlassian.jira.help.LocalHelpUrls;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.atlassian.util.concurrent.LazyReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalHelpUrls
implements LocalHelpUrls {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLocalHelpUrls.class);
    private static final String RESOURCE_NAME = "internal-help-paths.properties";
    private static final String PATH_SUFFIX = ".path";
    private static final String TITLE_SUFFIX = ".title";
    private final String resourceName;
    @ClusterSafe
    private LazyReference<Iterable<HelpUrl>> lazyReference = new LazyReference<Iterable<HelpUrl>>(){

        protected Iterable<HelpUrl> create() {
            return DefaultLocalHelpUrls.this.parse(DefaultLocalHelpUrls.this.loadProperties());
        }
    };

    public DefaultLocalHelpUrls() {
        this(RESOURCE_NAME);
    }

    @VisibleForTesting
    DefaultLocalHelpUrls(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    @Nonnull
    public Iterable<HelpUrl> parse(@Nonnull Properties properties) {
        HashMap helpPaths = Maps.newHashMap();
        for (String keyStr : properties.stringPropertyNames()) {
            String key;
            if (!StringUtils.endsWith((CharSequence)keyStr, (CharSequence)PATH_SUFFIX) || (key = StringUtils.stripToNull((String)StringUtils.removeEnd((String)keyStr, (String)PATH_SUFFIX))) == null) continue;
            String url = StringUtils.stripToNull((String)properties.getProperty(keyStr));
            String title = StringUtils.stripToNull((String)properties.getProperty(key + TITLE_SUFFIX));
            if (url == null || title == null) continue;
            helpPaths.put(key, new ImmutableHelpUrl(key, url, title, null, null, true));
        }
        return ImmutableList.copyOf(helpPaths.values());
    }

    @Override
    @Nonnull
    public Iterable<HelpUrl> load() {
        return (Iterable)this.lazyReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        Properties properties = new Properties();
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)this.resourceName, this.getClass());
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                LOG.error("Error loading '" + this.resourceName + "'.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        } else {
            LOG.error("Unable to find '{}' on the classpath.", (Object)this.resourceName);
        }
        return properties;
    }
}

