/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.HelpUrlBuilder;
import io.atlassian.fugue.Option;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

abstract class HelpUrlBuilderFactoryTemplate
implements HelpUrlBuilder.Factory {
    private static final Pattern DOC_VERSION_PATTERN = Pattern.compile("\\$\\{docs?\\.version\\}");
    private static final Pattern APPLICATION_HELP_SPACE_PATTERN = Pattern.compile("\\$\\{application\\.help\\.space\\}");
    private final String docsVersion;
    private final Option<String> applicationHelpSpaceVersion;

    HelpUrlBuilderFactoryTemplate(String docsVersion, Option<String> applicationHelpSpaceVersion) {
        this.docsVersion = docsVersion;
        this.applicationHelpSpaceVersion = applicationHelpSpaceVersion;
    }

    @Override
    public final HelpUrlBuilder get(String prefix, String suffix) {
        return this.newUrlBuilder(this.substitute(StringUtils.trimToNull((String)prefix)), StringUtils.trimToNull((String)suffix));
    }

    private String substitute(String inputString) {
        if (inputString == null) {
            return null;
        }
        Option stringWithHelpSpace = this.applicationHelpSpaceVersion.map(space -> APPLICATION_HELP_SPACE_PATTERN.matcher(inputString).replaceAll((String)space));
        return DOC_VERSION_PATTERN.matcher((CharSequence)stringWithHelpSpace.getOrElse((Object)inputString)).replaceAll(this.docsVersion);
    }

    abstract HelpUrlBuilder newUrlBuilder(String var1, String var2);
}

