/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceEvent;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.i18n.terminology.TerminologyCacheClearedEvent;
import com.atlassian.jira.i18n.terminology.TerminologyEntryDao;
import com.atlassian.jira.model.querydsl.NomenclatureEntryDTO;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@EventComponent
public class CachingTerminologyEntryDao
implements TerminologyEntryDao {
    public static final String TERMINOLOGY_CACHE_NAME = CachingTerminologyEntryDao.class.getCanonicalName() + ".entryCache";
    private final TerminologyEntryDao delegate;
    private final CachedReference<ListMultimap<String, NomenclatureEntryDTO>> entryCachedReference;

    public CachingTerminologyEntryDao(TerminologyEntryDao delegate, CacheManager cacheManager, final EventPublisher eventPublisher) {
        this.delegate = delegate;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).replicateViaInvalidation().build();
        this.entryCachedReference = cacheManager.getCachedReference(TERMINOLOGY_CACHE_NAME, this::loadTerminologyEntries, cacheSettings);
        this.entryCachedReference.addListener((CachedReferenceListener)new CachedReferenceListener<ListMultimap<String, NomenclatureEntryDTO>>(){

            public void onEvict(@Nonnull CachedReferenceEvent<ListMultimap<String, NomenclatureEntryDTO>> cachedReferenceEvent) {
            }

            public void onSet(@Nonnull CachedReferenceEvent<ListMultimap<String, NomenclatureEntryDTO>> cachedReferenceEvent) {
            }

            public void onReset(@Nonnull CachedReferenceEvent<ListMultimap<String, NomenclatureEntryDTO>> cachedReferenceEvent) {
                eventPublisher.publish((Object)new TerminologyCacheClearedEvent());
            }
        }, false);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.entryCachedReference.reset();
    }

    @Override
    public NomenclatureEntryDTO getTerminologyEntry(String originalName) {
        return ((ListMultimap)this.entryCachedReference.get()).get((Object)originalName).stream().findFirst().orElse(null);
    }

    @Override
    public Collection<NomenclatureEntryDTO> getAllTerminologyEntries() {
        return ((ListMultimap)this.entryCachedReference.get()).asMap().values().stream().map(list -> (NomenclatureEntryDTO)list.iterator().next()).collect(Collectors.toList());
    }

    @Override
    public Collection<NomenclatureEntryDTO> getHistoricalTerminologyEntries() {
        return ((ListMultimap)this.entryCachedReference.get()).values();
    }

    @Override
    public void setTerminologyEntries(Collection<NomenclatureEntryDTO> terminologyEntryDTOs) {
        this.delegate.setTerminologyEntries(terminologyEntryDTOs);
        this.entryCachedReference.reset();
    }

    private ListMultimap<String, NomenclatureEntryDTO> loadTerminologyEntries() {
        return (ListMultimap)this.delegate.getHistoricalTerminologyEntries().stream().sorted(Comparator.comparing(NomenclatureEntryDTO::getTimestamp).reversed()).collect(ImmutableListMultimap.toImmutableListMultimap(NomenclatureEntryDTO::getOriginalName, Function.identity()));
    }
}

