/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.text.WordUtils;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
final class TerminologyCapitalisationFormatter {
    TerminologyCapitalisationFormatter() {
    }

    String applyFormatting(String textToFormat, String originalText) {
        if (this.isUpperCapitalisation(originalText)) {
            return this.applyUpperCapitalisation(textToFormat);
        }
        if (this.isLowerCapitalisation(originalText)) {
            return this.applyLowerCapitalisation(textToFormat);
        }
        return this.applyTitleCapitalisation(textToFormat);
    }

    private boolean isUpperCapitalisation(String originalText) {
        return originalText.chars().noneMatch(Character::isLowerCase);
    }

    private String applyUpperCapitalisation(String textToFormat) {
        return textToFormat.toUpperCase();
    }

    private boolean isLowerCapitalisation(String originalText) {
        char firstCharacter = originalText.charAt(0);
        return Character.isLowerCase(firstCharacter);
    }

    private String applyLowerCapitalisation(String textToFormat) {
        return textToFormat.toLowerCase();
    }

    private String applyTitleCapitalisation(String textToFormat) {
        return WordUtils.capitalizeFully((String)textToFormat);
    }
}

