/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupProjectNameComparator;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.util.dbc.Null;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class BackupOverviewImpl
implements BackupOverview {
    private static final long serialVersionUID = -8149242078577537996L;
    private final transient Map<String, BackupProject> fullProjectsByKey;
    private final BackupSystemInformation backupSystemInformation;

    public BackupOverviewImpl(BackupSystemInformation backupSystemInformation, List<? extends BackupProject> backupProjects) {
        Null.not("backupSystemInformation", backupSystemInformation);
        Null.not("backupProjects", backupProjects);
        this.backupSystemInformation = backupSystemInformation;
        this.fullProjectsByKey = new ListOrderedMap();
        Collections.sort(backupProjects, new BackupProjectNameComparator());
        for (BackupProject backupProject : backupProjects) {
            this.fullProjectsByKey.put(backupProject.getProject().getKey(), backupProject);
        }
    }

    public BackupProject getProject(String projectKey) {
        return this.fullProjectsByKey.get(projectKey);
    }

    public List getProjects() {
        return new ArrayList<BackupProject>(this.fullProjectsByKey.values());
    }

    public BackupSystemInformation getBackupSystemInformation() {
        return this.backupSystemInformation;
    }
}

