/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.parser.CustomFieldValueParser;
import java.util.Map;

public class CustomFieldMapperHandler
implements ImportOfBizEntityHandler {
    private final BackupProject backupProject;
    private final CustomFieldMapper customFieldMapper;
    private final Map<String, CustomFieldValueParser> parsers;

    public CustomFieldMapperHandler(BackupProject backupProject, CustomFieldMapper customFieldMapper, Map<String, CustomFieldValueParser> parsers) {
        this.backupProject = backupProject;
        this.customFieldMapper = customFieldMapper;
        this.parsers = parsers;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        CustomFieldValueParser parser;
        ExternalCustomFieldValue externalCustomFieldValue;
        if (this.parsers.containsKey(entityName) && (externalCustomFieldValue = (parser = this.parsers.get(entityName)).parse(attributes)) != null && this.backupProject.containsIssue(externalCustomFieldValue.getIssueId())) {
            this.customFieldMapper.flagValueAsRequired(externalCustomFieldValue.getCustomFieldId(), externalCustomFieldValue.getIssueId());
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldMapperHandler that = (CustomFieldMapperHandler)o;
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        return !(this.customFieldMapper != null ? !this.customFieldMapper.equals((Object)that.customFieldMapper) : that.customFieldMapper != null);
    }

    public int hashCode() {
        int result = this.backupProject != null ? this.backupProject.hashCode() : 0;
        result = 31 * result + (this.customFieldMapper != null ? this.customFieldMapper.hashCode() : 0);
        return result;
    }
}

