/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalEntityProperty;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.EntityPropertyParser;
import com.atlassian.jira.imports.project.parser.EntityPropertyParserImpl;
import com.atlassian.jira.imports.project.transformer.EntityPropertyTransformer;
import com.atlassian.jira.imports.project.transformer.EntityPropertyTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityPropertiesPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(EntityPropertiesPersisterHandler.class);
    private final ProjectImportResults projectImportResults;
    private final ProjectImportPersister projectImportPersister;
    private final EntityPropertyType entityPropertyType;
    private final SimpleProjectImportIdMapper idMapperForType;
    private final EntityPropertyParser entityPropertyParser = new EntityPropertyParserImpl();
    private final EntityPropertyTransformer entityPropertyTransformer = new EntityPropertyTransformerImpl();

    public EntityPropertiesPersisterHandler(Executor executor, ProjectImportResults projectImportResults, ProjectImportPersister projectImportPersister, EntityPropertyType entityPropertyType, SimpleProjectImportIdMapper idMapperForType) {
        super(executor, projectImportResults);
        this.projectImportResults = projectImportResults;
        this.projectImportPersister = projectImportPersister;
        this.entityPropertyType = entityPropertyType;
        this.idMapperForType = idMapperForType;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("EntityProperty".equals(entityName)) {
            ExternalEntityProperty externalEntityProperty = this.getParser().parse(attributes);
            if (this.entityPropertyType.getDbEntityName().equals(externalEntityProperty.getEntityName()) && externalEntityProperty.getEntityId() != null) {
                String newEntityIdStr = this.idMapperForType.getMappedId(String.valueOf(externalEntityProperty.getEntityId()));
                if (newEntityIdStr != null) {
                    EntityRepresentation representation = this.getTransformer().getEntityRepresentation(externalEntityProperty, Long.valueOf(newEntityIdStr));
                    this.execute(() -> {
                        Long entityId = this.projectImportPersister.createEntity(representation);
                        if (entityId == null) {
                            this.projectImportResults.addError(this.projectImportResults.getI18n().getText("admin.errors.project.import.entity.property.error", String.valueOf(externalEntityProperty.getId()), externalEntityProperty.getEntityName(), String.valueOf(externalEntityProperty.getEntityId())));
                        }
                    });
                } else {
                    log.debug("Ignoring entity property id=" + externalEntityProperty.getId() + " entityName = " + externalEntityProperty.getEntityName());
                }
            }
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    private EntityPropertyParser getParser() {
        return this.entityPropertyParser;
    }

    private EntityPropertyTransformer getTransformer() {
        return this.entityPropertyTransformer;
    }
}

