/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.taskprogress;

import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public class ThrottlingTaskProgressProcessor
implements TaskProgressProcessor {
    private final TaskProgressProcessor taskProgressProcessor;
    private final Clock clock;
    private Instant nextUpdateTime;
    private static final Duration UPDATE_PROGRESS_PERIOD = Duration.ofSeconds(2L);

    public ThrottlingTaskProgressProcessor(@Nullable TaskProgressProcessor taskProgressProcessor, Clock clock) {
        this.taskProgressProcessor = taskProgressProcessor;
        this.clock = clock;
        this.nextUpdateTime = clock.instant();
    }

    public ThrottlingTaskProgressProcessor() {
        this.taskProgressProcessor = null;
        this.clock = null;
    }

    @Override
    public void processTaskProgress(String qName, int entityTypeCount, long entityCount, long currentEntityCount) {
        if (this.taskProgressProcessor != null && this.canUpdateProgress()) {
            this.nextUpdateTime = this.clock.instant().plus(UPDATE_PROGRESS_PERIOD);
            this.taskProgressProcessor.processTaskProgress(qName, entityTypeCount, entityCount, currentEntityCount);
        }
    }

    private boolean canUpdateProgress() {
        return this.clock.instant().isAfter(this.nextUpdateTime);
    }
}

