/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.concurrent.ResettableLazyReference;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.DelayCloseSearcher;
import com.atlassian.jira.index.DelayCloseable;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.MonitoringIndexWriter;
import com.atlassian.jira.index.PeriodicIndexWriterCommitScheduler;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.index.WriterWithStats;
import com.atlassian.jira.index.WriterWrapper;
import com.atlassian.jira.index.stats.IndexSearcherStats;
import com.atlassian.jira.index.stats.IndexSearcherWithStats;
import com.atlassian.jira.index.stats.NoOpIndexSearcherStats;
import com.atlassian.jira.index.stats.TotalAndSnapshotIndexSearcherStats;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.MapMaker;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultIndexEngine
implements DefaultIndex.Engine {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexEngine.class);
    private static final Ticker TICKER = Ticker.systemTicker();
    private final IndexSearcherStats indexSearcherStats;
    private final Set<UnmanagedIndexSearcher> weakUnmanagedSearchers = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final WriterReference writerReference;
    private final SearcherFactory searcherFactory;
    private final SearcherReference searcherReference;
    private final Configuration configuration;
    private final String indexName;

    DefaultIndexEngine(String indexName, @Nonnull Configuration configuration) {
        this(indexName, null, null, configuration);
    }

    DefaultIndexEngine(String indexName, @Nullable SearcherFactory searcherFactory, @Nullable Function<Index.UpdateMode, Writer> writerFactory, @Nonnull Configuration configuration) {
        this.indexName = (String)Assertions.notNull((String)"index name", (Object)indexName);
        this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        this.searcherFactory = searcherFactory != null ? searcherFactory : new SearcherFactoryImpl(configuration);
        this.searcherReference = new SearcherReference(this.searcherFactory);
        this.writerReference = new WriterReference(writerFactory == null ? new DefaultWriterFactory() : writerFactory);
        this.indexSearcherStats = this.getSearcherStats();
    }

    @Override
    @Nonnull
    public UnmanagedIndexSearcher getSearcher() {
        UnmanagedIndexSearcher unmanagedIndexSearcher = new UnmanagedIndexSearcher((DelayCloseSearcher)this.searcherReference.apply(Index.UpdateMode.INTERACTIVE));
        this.weakUnmanagedSearchers.add(unmanagedIndexSearcher);
        return unmanagedIndexSearcher;
    }

    @Override
    public void clean() {
        this.close();
        try {
            IndexWriterConfig luceneConfig = new IndexWriterConfig(this.configuration.getAnalyzer());
            luceneConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            MonitoringIndexWriter.create(this.configuration.getDirectory(), luceneConfig).close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void write(@Nonnull Index.Operation operation) throws IOException {
        try {
            log.trace("About to write to index: {} operation: {}", (Object)this.indexName, (Object)operation);
            ((Writer)this.writerReference.apply(operation.mode())).getFlushPolicy().perform(operation, this.writerReference);
            log.trace("Done writing to index: {} operation: {}", (Object)this.indexName, (Object)operation);
        }
        finally {
            log.trace("About to close current searcher: {} for index: {}", (Object)this.searcherReference, (Object)this.indexName);
            this.searcherReference.close();
            log.trace("Done closing searcher: {} for index: {}", (Object)this.searcherReference, (Object)this.indexName);
        }
    }

    @Override
    public void close() {
        this.writerReference.close();
        this.searcherReference.close();
        this.searcherFactory.release();
    }

    private IndexSearcherStats getSearcherStats() {
        boolean isTemporaryIndex = this.configuration.getDirectory() instanceof RAMDirectory;
        boolean isIssueIndex = this.indexName.equalsIgnoreCase(IndexDirectoryFactory.Name.ISSUE.toString());
        return !isTemporaryIndex && isIssueIndex ? new TotalAndSnapshotIndexSearcherStats(IndexDirectoryFactory.Name.ISSUE) : new NoOpIndexSearcherStats();
    }

    private class SearcherFactoryImpl
    implements SearcherFactory {
        private final Configuration configuration;
        private volatile DirectoryReader oldReader = null;

        SearcherFactoryImpl(Configuration configuration) {
            this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexSearcher get() {
            try {
                DirectoryReader reader;
                boolean newSearcherCreated;
                Stopwatch stopwatch;
                block11: {
                    stopwatch = Stopwatch.createStarted((Ticker)TICKER);
                    newSearcherCreated = false;
                    reader = null;
                    try {
                        if (this.oldReader != null) {
                            try {
                                reader = this.reopenIndexReader(this.oldReader);
                                if (reader == this.oldReader) break block11;
                                try {
                                    newSearcherCreated = true;
                                    this.oldReader.close();
                                    break block11;
                                }
                                catch (AlreadyClosedException ace) {
                                    log.debug("Tried to close an already closed reader.", (Throwable)ace);
                                }
                            }
                            catch (AlreadyClosedException ignore) {
                                log.warn("Tried to reopen the IndexReader, but it threw AlreadyClosedException. Opening a fresh IndexReader.");
                                newSearcherCreated = true;
                                reader = this.openIndexReader();
                            }
                            break block11;
                        }
                        newSearcherCreated = true;
                        reader = this.openIndexReader();
                    }
                    finally {
                        this.oldReader = reader;
                    }
                }
                IndexSearcherWithStats indexSearcher = new IndexSearcherWithStats((IndexReader)reader, DefaultIndexEngine.this.indexSearcherStats);
                DefaultIndexEngine.this.indexSearcherStats.onGetSearcherTotal(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                if (newSearcherCreated) {
                    DefaultIndexEngine.this.indexSearcherStats.onGetNewSearcher(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                }
                return indexSearcher;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        private DirectoryReader openIndexReader() throws IOException {
            if (this.useNRT()) {
                return DirectoryReader.open((IndexWriter)((Writer)DefaultIndexEngine.this.writerReference.apply(Index.UpdateMode.INTERACTIVE)).getLuceneWriter());
            }
            ((Writer)DefaultIndexEngine.this.writerReference.apply(Index.UpdateMode.INTERACTIVE)).getLuceneWriter().commit();
            return DirectoryReader.open((Directory)this.configuration.getDirectory());
        }

        private DirectoryReader reopenIndexReader(DirectoryReader reader) throws IOException {
            DirectoryReader reopenedReader = this.reopenIndexReaderOrNullIfUnchanged(reader);
            return reopenedReader != null ? reopenedReader : reader;
        }

        private DirectoryReader reopenIndexReaderOrNullIfUnchanged(DirectoryReader reader) throws IOException {
            if (this.useNRT()) {
                return DirectoryReader.openIfChanged((DirectoryReader)reader, (IndexWriter)((Writer)DefaultIndexEngine.this.writerReference.apply(Index.UpdateMode.INTERACTIVE)).getLuceneWriter());
            }
            return DirectoryReader.openIfChanged((DirectoryReader)reader);
        }

        private boolean useNRT() {
            return FlushPolicy.PERIODIC.equals((Object)((Writer)DefaultIndexEngine.this.writerReference.apply(Index.UpdateMode.INTERACTIVE)).getFlushPolicy());
        }

        @Override
        public void release() {
            DirectoryReader reader = this.oldReader;
            if (reader != null) {
                try {
                    reader.close();
                    this.oldReader = null;
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static interface SearcherFactory
    extends Supplier<IndexSearcher> {
        public void release();
    }

    static abstract class ReferenceHolder<T>
    implements Function<Index.UpdateMode, T>,
    Closeable {
        private final ResettableLazyReference<T> reference = new ResettableLazyReference();
        private final Effect<T> resetEffect = new Effect<T>(){

            public void apply(T localReference) {
                try {
                    this.doClose(localReference);
                }
                catch (RuntimeException e) {
                    log.error("Error closing reference: {}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
        };

        ReferenceHolder() {
        }

        final void safeClose(T expected) {
            this.reference.safeReset(expected).foreach(this.resetEffect);
        }

        @Override
        public final void close() {
            this.reference.reset().foreach(this.resetEffect);
        }

        abstract void doClose(T var1);

        public final T apply(final Index.UpdateMode mode) {
            while (true) {
                try {
                    return this.open(this.reference.getOrCreate(new Supplier<T>(){

                        public T get() {
                            return this.doCreate(mode);
                        }
                    }));
                }
                catch (DelayCloseable.AlreadyClosedException ace) {
                    log.debug("Already closed", (Throwable)((Object)ace));
                    continue;
                }
                break;
            }
        }

        abstract T doCreate(Index.UpdateMode var1);

        abstract T open(T var1);

        final Option<T> get() {
            return this.reference.get();
        }
    }

    private class DefaultWriterFactory
    implements Function<Index.UpdateMode, Writer> {
        private DefaultWriterFactory() {
        }

        public Writer apply(Index.UpdateMode mode) {
            return WriterWithStats.maybeWrap(new WriterWrapper(DefaultIndexEngine.this.indexName, DefaultIndexEngine.this.configuration, mode, (Supplier<UnmanagedIndexSearcher>)((Supplier)() -> DefaultIndexEngine.this.getSearcher())), DefaultIndexEngine.this.configuration.getDirectory() instanceof RAMDirectory);
        }
    }

    @ThreadSafe
    protected static class WriterReference
    extends ReferenceHolder<Writer> {
        private final Function<Index.UpdateMode, Writer> writerFactory;

        WriterReference(@Nonnull Function<Index.UpdateMode, Writer> writerFactory) {
            this.writerFactory = (Function)Assertions.notNull((String)"writerFactory", writerFactory);
        }

        public void commit() {
            Option writerOption = this.get();
            if (writerOption.isDefined()) {
                try {
                    ((Writer)writerOption.get()).commit();
                }
                catch (IllegalStateException ise) {
                    log.error("Hit an exception committing writes to the index; discarding the current writer!", (Throwable)ise);
                    this.safeClose(writerOption.get());
                    throw ise;
                }
            }
        }

        @Override
        Writer doCreate(Index.UpdateMode mode) {
            return (Writer)this.writerFactory.apply((Object)mode);
        }

        @Override
        void doClose(Writer writer) {
            writer.close();
        }

        @Override
        Writer open(Writer writer) {
            return writer;
        }
    }

    @ThreadSafe
    private class SearcherReference
    extends ReferenceHolder<DelayCloseSearcher> {
        private final SearcherFactory searcherSupplier;

        SearcherReference(SearcherFactory searcherSupplier) {
            this.searcherSupplier = (SearcherFactory)Assertions.notNull((String)"searcherSupplier", (Object)searcherSupplier);
        }

        @Override
        DelayCloseSearcher doCreate(Index.UpdateMode mode) {
            DelayCloseSearcher delayCloseSearcher = new DelayCloseSearcher((IndexSearcher)this.searcherSupplier.get());
            return delayCloseSearcher;
        }

        @Override
        DelayCloseSearcher open(DelayCloseSearcher searcher) {
            searcher.open();
            return searcher;
        }

        @Override
        void doClose(DelayCloseSearcher searcher) {
            searcher.closeWhenDone();
        }
    }

    public static enum FlushPolicy {
        PERIODIC{

            @Override
            void commit(WriterReference writer) {
                PeriodicIndexWriterCommitScheduler commitScheduler = (PeriodicIndexWriterCommitScheduler)ComponentAccessor.getComponent(PeriodicIndexWriterCommitScheduler.class);
                commitScheduler.scheduleForCommit(writer);
            }
        };


        void perform(Index.Operation operation, WriterReference writer) throws IOException {
            try {
                operation.perform((Writer)writer.apply(operation.mode()));
            }
            finally {
                this.commit(writer);
            }
        }

        abstract void commit(WriterReference var1);
    }
}

