/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.util.stats.JiraStats;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringIndexWriter
extends IndexWriter {
    private static final Logger log = LoggerFactory.getLogger(MonitoringIndexWriter.class);
    private static final String PREFIX = "[lucene-stats] ";
    private final AtomicLong flushCounterSnapshot = new AtomicLong();
    private final AtomicLong flushCounterTotal = new AtomicLong();
    private final AtomicLong documentCounterSnapshot = new AtomicLong();
    private final AtomicLong documentCounterTotal = new AtomicLong();
    private final Stopwatch lastPrintStats;
    private static final long STATS_PERIOD_MILLIS = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MILLISECONDS);
    private static final long WARN_REASONABLE_VALUE_OF_STATS_PERIOD_MILLIS = STATS_PERIOD_MILLIS / 2L;
    private static final String SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS = "jira.index.warn.flush.min.interval.millis";
    private static final String KB_URL = "https://confluence.atlassian.com/x/w0VwOQ";

    MonitoringIndexWriter(Directory d, IndexWriterConfig conf, Ticker ticker) throws IOException {
        super(d, conf);
        this.lastPrintStats = Stopwatch.createStarted((Ticker)ticker);
        log.trace("[lucene-stats] stats will be running every: {} millis", (Object)STATS_PERIOD_MILLIS);
    }

    private static long warnMinFlushIntervalMillis(long defaultValue) {
        try {
            return Long.parseLong(JiraSystemProperties.getInstance().getProperty(SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS, defaultValue + ""));
        }
        catch (Exception e) {
            log.error("Error when getting system property value: {}. Using default value: {}", new Object[]{SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS, defaultValue, e});
            return defaultValue;
        }
    }

    public static MonitoringIndexWriter create(Directory d, IndexWriterConfig conf) throws IOException {
        return new MonitoringIndexWriter(d, conf, Ticker.systemTicker());
    }

    public long addDocument(Iterable<? extends IndexableField> doc) throws IOException {
        this.documentCounterTotal.incrementAndGet();
        this.documentCounterSnapshot.incrementAndGet();
        return super.addDocument(doc);
    }

    public long addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        if (docs instanceof Collection) {
            int size = ((Collection)docs).size();
            this.documentCounterTotal.addAndGet(size);
            this.documentCounterSnapshot.addAndGet(size);
        }
        return super.addDocuments(docs);
    }

    protected void doAfterFlush() {
        try {
            this.flushCounterSnapshot.incrementAndGet();
            this.flushCounterTotal.incrementAndGet();
            this.printStatsNotToOften();
        }
        catch (Exception e) {
            log.error("Error when monitoring lucene flushes in doAfterFlush(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block6: {
            super.close();
            try {
                Directory directory = this.getDirectory();
                if (directory instanceof RAMDirectory) {
                    log.trace("{}Not printing lucene-stats when closing index writer for directory: {}", (Object)PREFIX, (Object)directory);
                    break block6;
                }
                MonitoringIndexWriter monitoringIndexWriter = this;
                synchronized (monitoringIndexWriter) {
                    this.printAndResetStats();
                }
            }
            catch (Exception e) {
                log.error("Error when monitoring lucene flushes in close(): {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Nullable
    private Path getDirectoryPath() {
        Directory directory = this.getDirectory();
        if (directory instanceof FSDirectory) {
            return ((FSDirectory)directory).getDirectory();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStatsNotToOften() {
        if (this.canPrintStats()) {
            MonitoringIndexWriter monitoringIndexWriter = this;
            synchronized (monitoringIndexWriter) {
                if (this.canPrintStats()) {
                    this.printAndResetStats();
                }
            }
        }
    }

    private boolean canPrintStats() {
        return this.lastPrintStats.elapsed(TimeUnit.MILLISECONDS) > STATS_PERIOD_MILLIS;
    }

    private void printAndResetStats() {
        if (this.flushCounterSnapshot.get() > 0L) {
            boolean isForegroundIndexing = ComponentAccessor.getComponentSafely(IndexingConfiguration.class).map(i -> !i.isIndexAvailable()).orElse(false);
            long periodMillis = this.lastPrintStats.elapsed(TimeUnit.MILLISECONDS);
            long counterSnapshot = this.flushCounterSnapshot.get();
            long counterTotal = this.flushCounterTotal.get();
            long flushIntervalMillis = periodMillis / counterSnapshot;
            log.info("[JIRA-STATS] [lucene-stats] flush stats: isForegroundIndexing={}, snapshotCount={}, totalCount={}, periodSec={}, flushIntervalMillis={}, snapshotNoDocs={}, totalNoDocs={}, indexDirectory={}, indexWriterId={}, indexDirectoryId={}", new Object[]{isForegroundIndexing, counterSnapshot, counterTotal, TimeUnit.MILLISECONDS.toSeconds(periodMillis), flushIntervalMillis, this.documentCounterSnapshot.get(), this.documentCounterTotal.get(), this.getDirectoryPath(), ((Object)((Object)this)).toString(), this.getDirectory()});
            long warnMinFlushIntervalMillis = MonitoringIndexWriter.warnMinFlushIntervalMillis(1000L);
            if (isForegroundIndexing && periodMillis > WARN_REASONABLE_VALUE_OF_STATS_PERIOD_MILLIS && flushIntervalMillis < warnMinFlushIntervalMillis) {
                log.warn("[lucene-stats] Detected frequent flushes (every {} millis) of lucene index which is below warning limit: {}={} millis. This may affect the foreground indexing performance. Please visit {} for more information.", new Object[]{flushIntervalMillis, SYSTEM_PROPERTY_NAME_WARN_MIN_FLUSH_INTERVAL_MILLIS, warnMinFlushIntervalMillis, KB_URL});
            }
            this.flushCounterSnapshot.set(0L);
            this.documentCounterSnapshot.set(0L);
        }
        this.lastPrintStats.reset().start();
    }
}

