/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.annotations.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class QueueingIndexPriority {
    private static final Logger log = LoggerFactory.getLogger(QueueingIndexPriority.class);
    static final ThreadLocal<Integer> priority = new ThreadLocal();

    public static void runWithIndexingPriority(Runnable runInNewPriority, int newPriority) {
        Integer priorityBefore = priority.get();
        priority.set(newPriority);
        log.trace("[INDEXING-QUEUE] Running with custom indexing priority:{}", (Object)newPriority);
        try {
            runInNewPriority.run();
        }
        finally {
            log.trace("[INDEXING-QUEUE] Restoring indexing priority back to:{}", (Object)priorityBefore);
            if (priorityBefore == null) {
                priority.remove();
            } else {
                priority.set(priorityBefore);
            }
        }
    }

    static int getPriority() {
        Integer currentPriority = priority.get();
        return currentPriority != null ? currentPriority : 0;
    }
}

