/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.util.Supplier;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ReusableIndexSearcher {
    private static final Logger log = LoggerFactory.getLogger(ReusableIndexSearcher.class);
    private final SearcherStats.DefaultSearcherStats searcherStats = new SearcherStats.DefaultSearcherStats();
    private final Supplier<UnmanagedIndexSearcher> indexSearcherSupplier;
    private UnmanagedIndexSearcher indexSearcher;

    ReusableIndexSearcher(Supplier<UnmanagedIndexSearcher> indexSearcherSupplier) {
        this.indexSearcherSupplier = indexSearcherSupplier;
    }

    TopDocs search(Query query, int n) throws IOException {
        this.ensureOpened();
        return this.indexSearcher.search(query, n);
    }

    Document doc(int n, Set<String> fieldsToLoad) throws IOException {
        this.ensureOpened();
        return this.indexSearcher.doc(n, fieldsToLoad);
    }

    int getHashCode() {
        return this.indexSearcher != null ? this.indexSearcher.hashCode() : -1;
    }

    void close() {
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
            this.indexSearcher = null;
            log.trace("Closed searcher");
        }
    }

    SearcherStats.MutableSearcherStats.Result getTotal() {
        return this.searcherStats.total.result(false);
    }

    SearcherStats.MutableSearcherStats.Result getSnapshotAndReset() {
        return this.searcherStats.snapshot.result(true);
    }

    private void ensureOpened() {
        if (this.indexSearcher == null) {
            this.indexSearcher = (UnmanagedIndexSearcher)this.indexSearcherSupplier.get();
            this.searcherStats.onCreateNew();
            log.trace("Created searcher");
        } else {
            this.searcherStats.onReuse();
        }
    }

    static interface SearcherStats {
        public void onCreateNew();

        public void onReuse();

        public static SearcherStats create() {
            return new DefaultSearcherStats();
        }

        public static class DefaultSearcherStats
        implements SearcherStats {
            private final MutableSearcherStats snapshot = new MutableSearcherStats();
            private final MutableSearcherStats total = new MutableSearcherStats();

            @Override
            public void onCreateNew() {
                this.snapshot.onCreateNew();
                this.total.onCreateNew();
            }

            @Override
            public void onReuse() {
                this.snapshot.onReuse();
                this.total.onReuse();
            }
        }

        public static class MutableSearcherStats
        implements SearcherStats {
            private final AtomicLong createNew = new AtomicLong();
            private final AtomicLong reuse = new AtomicLong();

            void reset() {
                this.createNew.set(0L);
                this.reuse.set(0L);
            }

            Result result(boolean reset) {
                Result result = new Result();
                if (reset) {
                    this.reset();
                }
                return result;
            }

            @Override
            public void onCreateNew() {
                this.createNew.incrementAndGet();
            }

            @Override
            public void onReuse() {
                this.reuse.incrementAndGet();
            }

            final class Result {
                final long createNew;
                final long reuse;

                Result() {
                    this.createNew = MutableSearcherStats.this.createNew.get();
                    this.reuse = MutableSearcherStats.this.reuse.get();
                }
            }
        }
    }
}

