/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.jira.index.DefaultIndexEngine;
import com.atlassian.jira.index.ReusableIndexSearcher;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.index.WriterWrapper;
import com.atlassian.jira.index.WriterWrapperEntityVersionCache;
import com.atlassian.jira.ipd.JiraIpdMainRegistry;
import com.atlassian.jira.ipd.index.IpdIndexWriterStats;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterWithStats
implements Writer {
    static final AtomicInteger instanceCounter = new AtomicInteger(0);
    static final String LOGPREFIX = "[index-writer-stats] ";
    private static final Logger log = LoggerFactory.getLogger(WriterWithStats.class);
    private static Ticker TICKER = Ticker.systemTicker();
    private final TotalAndSnapshotWriterStats stats;
    private final WriterWrapper delegate;
    private final ScheduledExecutorService executorService;
    private static final Set<IndexDirectoryFactory.Name> supportedIndexNames = ImmutableSet.of((Object)((Object)IndexDirectoryFactory.Name.ISSUE), (Object)((Object)IndexDirectoryFactory.Name.COMMENT), (Object)((Object)IndexDirectoryFactory.Name.WORKLOG), (Object)((Object)IndexDirectoryFactory.Name.CHANGE_HISTORY));

    WriterWithStats(WriterWrapper delegate) {
        this(delegate, new TotalAndSnapshotWriterStats(delegate));
    }

    WriterWithStats(WriterWrapper delegate, TotalAndSnapshotWriterStats stats) {
        instanceCounter.incrementAndGet();
        this.stats = stats;
        this.delegate = delegate;
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("index-writer-stats-" + delegate.getIndexNameAsString() + "-" + instanceCounter.get() + "-%d").build());
    }

    static boolean shouldProduceStats(WriterWrapper delegate) {
        Optional<IndexDirectoryFactory.Name> indexName = delegate.getIndexName();
        return indexName.isPresent() && supportedIndexNames.contains((Object)indexName.get());
    }

    public static Writer maybeWrap(WriterWrapper delegate, boolean isRamDirectory) {
        if (!isRamDirectory && WriterWithStats.shouldProduceStats(delegate)) {
            log.info("[index-writer-stats] Creating #{} writer stats for: {}", (Object)instanceCounter.get(), (Object)delegate.getIndexNameAsString());
            WriterWithStats writerWithStats = new WriterWithStats(delegate);
            writerWithStats.start();
            return writerWithStats;
        }
        log.trace("[index-writer-stats] Not creating writer stats for: delegate={}, isRamDirectory={}", (Object)delegate.getIndexNameAsString(), (Object)isRamDirectory);
        return delegate;
    }

    private String getPrefix() {
        return LOGPREFIX + this.delegate.getIndexNameAsString() + " : ";
    }

    void start() {
        long periodInMin = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MINUTES);
        log.info("{}indexing writer stats will be running every: {} min", (Object)this.getPrefix(), (Object)periodInMin);
        this.executorService.scheduleAtFixedRate(this::onPeriodicStats, 5L, periodInMin, TimeUnit.MINUTES);
    }

    private void stop() {
        this.executorService.shutdownNow();
    }

    void onPeriodicStats() {
        try {
            MutableWriterStats.Result totalResult = this.stats.getTotal();
            WriterWrapperEntityVersionCache.CacheStats.MutableCacheStats.Result totalCacheStatsResult = this.delegate.totalCacheStats();
            ReusableIndexSearcher.SearcherStats.MutableSearcherStats.Result totalSearcherStatsResult = this.delegate.totalSearcherStats();
            MutableWriterStats.Result snapshotResult = this.stats.getSnapshotAndReset();
            WriterWrapperEntityVersionCache.CacheStats.MutableCacheStats.Result snapshotCacheStatsResult = this.delegate.snapshotCacheStats();
            ReusableIndexSearcher.SearcherStats.MutableSearcherStats.Result snapshotSearcherStatsResult = this.delegate.snapshotSearcherStats();
            Gson gson = new Gson();
            String totalJson = gson.toJson((Object)totalResult);
            String totalCacheStatsJson = gson.toJson((Object)totalCacheStatsResult);
            String totalSearcherStatsJson = gson.toJson((Object)totalSearcherStatsResult);
            String snapshotJson = gson.toJson((Object)snapshotResult);
            String snapshotCacheStatsJson = gson.toJson((Object)snapshotCacheStatsResult);
            String snapshotSearcherStatsJson = gson.toJson((Object)snapshotSearcherStatsResult);
            log.info("[JIRA-STATS] {}total stats: {}, index writer version cache stats: {}, index writer searcher stats: {}", new Object[]{this.getPrefix(), totalJson, totalCacheStatsJson, totalSearcherStatsJson});
            log.info("[JIRA-STATS] {}snapshot stats: {}, index writer version cache stats: {}, index writer searcher stats: {}", new Object[]{this.getPrefix(), snapshotJson, snapshotCacheStatsJson, snapshotSearcherStatsJson});
        }
        catch (Throwable throwable) {
            log.error("{}Error when getting periodic indexing stats: {}", new Object[]{this.getPrefix(), throwable.getMessage(), throwable});
        }
    }

    @Override
    public IndexWriter getLuceneWriter() {
        return this.delegate.getLuceneWriter();
    }

    @Override
    public void addDocuments(@Nonnull Collection<Document> document) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.addDocuments(document);
        }
        finally {
            this.stats.onAddDocuments(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void deleteDocuments(@Nonnull Term identifyingTerm) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.deleteDocuments(identifyingTerm);
        }
        finally {
            this.stats.onDeleteDocuments(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDocuments(@Nonnull Term identifyingTerm, @Nonnull Collection<Document> document) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.updateDocuments(identifyingTerm, document);
        }
        finally {
            this.stats.onUpdateDocuments(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDocumentConditionally(@Nonnull Term identifyingTerm, @Nonnull Document document, @Nonnull String optimisticLockField) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.updateDocumentConditionally(identifyingTerm, document, optimisticLockField);
        }
        finally {
            this.stats.onUpdateDocumentConditionally(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateDocumentsWithVersion(@Nonnull Collection<Document> newDocuments) throws IOException, IllegalStateException, IllegalArgumentException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            int n = this.delegate.updateDocumentsWithVersion(newDocuments);
            return n;
        }
        finally {
            this.stats.onUpdateDocumentsWithVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS), newDocuments.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceDocumentsWithVersion(@Nonnull Collection<Document> newDocuments) throws IOException, IllegalStateException, IllegalArgumentException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            boolean bl = this.delegate.replaceDocumentsWithVersion(newDocuments);
            return bl;
        }
        finally {
            this.stats.onReplaceDocumentsWithVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS), newDocuments.size());
        }
    }

    @Override
    public void optimize() throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.optimize();
        }
        finally {
            this.stats.onOptimize(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void close() {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.close();
        }
        finally {
            this.stats.onClose(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            try {
                log.info(this.getPrefix() + "Stopping writer stats.");
                this.stop();
            }
            catch (Throwable t) {
                log.error(this.getPrefix() + "Error when trying to stop writer stats: " + t.getMessage(), t);
            }
        }
    }

    @Override
    public void commit() {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.commit();
        }
        finally {
            this.stats.onCommit(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
        return this.delegate.getFlushPolicy();
    }

    @Override
    public long getCommitFrequency() {
        return this.delegate.getCommitFrequency();
    }

    static class MutableWriterStats
    implements WriterStats {
        private final MutableLongStats addDocumentsMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats deleteDocumentsMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats updateDocumentsMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats updateDocumentConditionallyMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats updateDocumentsWithVersionMillis = new MutableLongStats(new long[]{10L, 100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L});
        private final MutableLongStats updateDocumentsWithVersionSize = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 10000L});
        private final MutableLongStats replaceDocumentsWithVersionMillis = new MutableLongStats(new long[]{10L, 100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L});
        private final MutableLongStats replaceDocumentsWithVersionSize = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 10000L});
        private final MutableLongStats optimizeMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats closeMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats commitMillis = new MutableLongStats(new long[0]);

        MutableWriterStats() {
        }

        void reset() {
            this.addDocumentsMillis.reset();
            this.deleteDocumentsMillis.reset();
            this.updateDocumentsMillis.reset();
            this.updateDocumentConditionallyMillis.reset();
            this.updateDocumentsWithVersionMillis.reset();
            this.updateDocumentsWithVersionSize.reset();
            this.replaceDocumentsWithVersionMillis.reset();
            this.replaceDocumentsWithVersionSize.reset();
            this.optimizeMillis.reset();
            this.closeMillis.reset();
            this.commitMillis.reset();
        }

        @Override
        public void onAddDocuments(long millis) {
            this.addDocumentsMillis.accept(millis);
        }

        @Override
        public void onDeleteDocuments(long millis) {
            this.deleteDocumentsMillis.accept(millis);
        }

        @Override
        public void onUpdateDocuments(long millis) {
            this.updateDocumentsMillis.accept(millis);
        }

        @Override
        public void onUpdateDocumentConditionally(long millis) {
            this.updateDocumentConditionallyMillis.accept(millis);
        }

        @Override
        public void onUpdateDocumentsWithVersion(long millis, int size) {
            this.updateDocumentsWithVersionMillis.accept(millis);
            this.updateDocumentsWithVersionSize.accept((long)size);
        }

        @Override
        public void onReplaceDocumentsWithVersion(long millis, int size) {
            this.replaceDocumentsWithVersionMillis.accept(millis);
            this.replaceDocumentsWithVersionSize.accept((long)size);
        }

        @Override
        public void onOptimize(long millis) {
            this.optimizeMillis.accept(millis);
        }

        @Override
        public void onClose(long millis) {
            this.closeMillis.accept(millis);
        }

        @Override
        public void onCommit(long millis) {
            this.commitMillis.accept(millis);
        }

        Result get() {
            return new Result();
        }

        class Result {
            private final LongStats addDocumentsMillis;
            private final LongStats deleteDocumentsMillis;
            private final LongStats updateDocumentsMillis;
            private final LongStats updateDocumentConditionallyMillis;
            private final LongStats updateDocumentsWithVersionMillis;
            private final LongStats updateDocumentsWithVersionSize;
            private final LongStats replaceDocumentsWithVersionMillis;
            private final LongStats replaceDocumentsWithVersionSize;
            private final LongStats optimizeMillis;
            private final LongStats closeMillis;
            private final LongStats commitMillis;

            Result() {
                this.addDocumentsMillis = MutableWriterStats.this.addDocumentsMillis.get();
                this.deleteDocumentsMillis = MutableWriterStats.this.deleteDocumentsMillis.get();
                this.updateDocumentsMillis = MutableWriterStats.this.updateDocumentsMillis.get();
                this.updateDocumentConditionallyMillis = MutableWriterStats.this.updateDocumentConditionallyMillis.get();
                this.updateDocumentsWithVersionMillis = MutableWriterStats.this.updateDocumentsWithVersionMillis.get();
                this.updateDocumentsWithVersionSize = MutableWriterStats.this.updateDocumentsWithVersionSize.get();
                this.replaceDocumentsWithVersionMillis = MutableWriterStats.this.replaceDocumentsWithVersionMillis.get();
                this.replaceDocumentsWithVersionSize = MutableWriterStats.this.replaceDocumentsWithVersionSize.get();
                this.optimizeMillis = MutableWriterStats.this.optimizeMillis.get();
                this.closeMillis = MutableWriterStats.this.closeMillis.get();
                this.commitMillis = MutableWriterStats.this.commitMillis.get();
            }
        }
    }

    static class TotalAndSnapshotWriterStats
    implements WriterStats {
        private MutableWriterStats total = new MutableWriterStats();
        private MutableWriterStats snapshot = new MutableWriterStats();
        private IpdIndexWriterStats ipdStats;

        public TotalAndSnapshotWriterStats(WriterWrapper delegate) {
            this(delegate, JiraIpdMainRegistry.instance());
        }

        @VisibleForTesting
        TotalAndSnapshotWriterStats(WriterWrapper delegate, IpdMainRegistry ipdMainRegistry) {
            this(!String.valueOf((Object)IndexDirectoryFactory.Name.ISSUE).equals(delegate.getIndexNameAsString()) ? null : new IpdIndexWriterStats((IpdMetricRegistry)ipdMainRegistry));
        }

        @VisibleForTesting
        TotalAndSnapshotWriterStats(IpdIndexWriterStats ipdStats) {
            this.ipdStats = ipdStats;
        }

        public MutableWriterStats.Result getTotal() {
            return this.total.get();
        }

        MutableWriterStats.Result getSnapshotAndReset() {
            MutableWriterStats.Result result = this.snapshot.get();
            this.snapshot.reset();
            return result;
        }

        @Override
        public void onAddDocuments(long millis) {
            this.total.onAddDocuments(millis);
            this.snapshot.onAddDocuments(millis);
        }

        @Override
        public void onDeleteDocuments(long millis) {
            this.total.onDeleteDocuments(millis);
            this.snapshot.onDeleteDocuments(millis);
        }

        @Override
        public void onUpdateDocuments(long millis) {
            this.total.onUpdateDocuments(millis);
            this.snapshot.onUpdateDocuments(millis);
        }

        @Override
        public void onUpdateDocumentConditionally(long millis) {
            this.total.onUpdateDocumentConditionally(millis);
            this.snapshot.onUpdateDocumentConditionally(millis);
        }

        @Override
        public void onUpdateDocumentsWithVersion(long millis, int size) {
            this.total.onUpdateDocumentsWithVersion(millis, size);
            this.snapshot.onUpdateDocumentsWithVersion(millis, size);
        }

        @Override
        public void onReplaceDocumentsWithVersion(long millis, int size) {
            this.total.onReplaceDocumentsWithVersion(millis, size);
            this.snapshot.onReplaceDocumentsWithVersion(millis, size);
        }

        @Override
        public void onOptimize(long millis) {
            this.total.onOptimize(millis);
            this.snapshot.onOptimize(millis);
        }

        @Override
        public void onClose(long millis) {
            this.total.onClose(millis);
            this.snapshot.onClose(millis);
            if (this.ipdStats != null) {
                this.ipdStats.close();
            }
        }

        @Override
        public void onCommit(long millis) {
            this.total.onCommit(millis);
            this.snapshot.onCommit(millis);
            if (this.ipdStats != null) {
                this.ipdStats.updateWriteLatency(millis);
            }
        }
    }

    static interface WriterStats {
        public void onAddDocuments(long var1);

        public void onDeleteDocuments(long var1);

        public void onUpdateDocuments(long var1);

        public void onUpdateDocumentConditionally(long var1);

        public void onUpdateDocumentsWithVersion(long var1, int var3);

        public void onReplaceDocumentsWithVersion(long var1, int var3);

        public void onOptimize(long var1);

        public void onClose(long var1);

        public void onCommit(long var1);
    }
}

