/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.index.IndexCounterManager;
import com.atlassian.jira.index.ha.OfBizNodeIndexCounterStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeIndexCounterManager
extends IndexCounterManager {
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeIndexCounterManager.class);
    private final OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore;
    private final ClusterManager clusterManager;
    private final Map<String, Long> bufferedIndexCounters = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> preparedIndexCounters = new HashMap<String, Long>();

    public ClusterNodeIndexCounterManager(OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore, ClusterManager clusterManager) {
        this.ofBizNodeIndexCounterStore = ofBizNodeIndexCounterStore;
        this.clusterManager = clusterManager;
    }

    @Override
    public void storeHighestIdForNode(String sendingNodeId, long indexOperationId) {
        log.trace("[INDEX-REPLAY] Adding for current node ({}) : {} replicatedIndexOperation: {}", new Object[]{this.clusterManager.getNodeId(), sendingNodeId, indexOperationId});
        this.bufferedIndexCounters.put(sendingNodeId, indexOperationId);
    }

    @Override
    public long getIndexOperationCounterForNodeId(String sendingNodeId) {
        String currentNodeId = this.clusterManager.getNodeId();
        Long bufferedIndexCounter = this.bufferedIndexCounters.get(sendingNodeId);
        Long dbIndexCounter = bufferedIndexCounter == null || log.isTraceEnabled() ? Long.valueOf(this.ofBizNodeIndexCounterStore.getIndexOperationCounterForNodeId(currentNodeId, sendingNodeId)) : null;
        log.trace("[INDEX-REPLAY] getIndexOperationCounterForNodeId sendingNodeId={}, bufferedIndexCounter={}, dbIndexCounter={} {}", new Object[]{sendingNodeId, bufferedIndexCounter, dbIndexCounter, bufferedIndexCounter != null && dbIndexCounter != null && bufferedIndexCounter < dbIndexCounter ? "bufferedIndexCounter is behind dbIndexCounter" : ""});
        return bufferedIndexCounter != null ? bufferedIndexCounter : dbIndexCounter;
    }

    @Override
    public void onBeforeCommit() {
        log.trace("[INDEX-REPLAY] onBeforeCommit: bufferedIndexCounters={}, preparedIndexCounters={}", this.bufferedIndexCounters, this.preparedIndexCounters);
        this.preparedIndexCounters.putAll(this.bufferedIndexCounters);
    }

    @Override
    public void onAfterCommit() {
        log.trace("[INDEX-REPLAY] onAfterCommit - entry, bufferedIndexCounters={}, preparedIndexCounters={}", this.bufferedIndexCounters, this.preparedIndexCounters);
        String currentNodeId = this.clusterManager.getNodeId();
        for (Map.Entry<String, Long> nodeOperation : this.preparedIndexCounters.entrySet()) {
            this.ofBizNodeIndexCounterStore.storeHighestIdForNode(currentNodeId, nodeOperation.getKey(), nodeOperation.getValue());
            this.bufferedIndexCounters.remove(nodeOperation.getKey(), nodeOperation.getValue());
        }
        this.preparedIndexCounters.clear();
        log.trace("[INDEX-REPLAY] onAfterCommit - exit, bufferedIndexCounters={}", this.bufferedIndexCounters);
    }
}

