/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.lock.ClusterLockCleanupDao;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.index.ha.events.DisasterRecoveryEvent;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.task.TaskProgressSink;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisasterRecoveryLauncher {
    private static final String DR_PROPERTY_KEY = "disaster.recovery";
    private static final Logger LOG = LoggerFactory.getLogger(DisasterRecoveryLauncher.class);

    public RecoveryMode getRecoveryMode() {
        if (!((ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class)).getOption(DR_PROPERTY_KEY)) {
            return RecoveryMode.PRIMARY;
        }
        if (!((ClusterManager)ComponentAccessor.getComponent(ClusterManager.class)).isClusterLicensed()) {
            LOG.warn("***********************************************************************************************");
            LOG.warn(" Trying to activate Disaster recovery mode without a Data Center license. Skipping...");
            LOG.warn("***********************************************************************************************");
            return RecoveryMode.PRIMARY;
        }
        if (this.getSnapshotArchiveDirectory().exists()) {
            return RecoveryMode.SECONDARY;
        }
        return RecoveryMode.COLD;
    }

    public void start() {
        RecoveryMode mode = this.getRecoveryMode();
        if (mode == RecoveryMode.COLD) {
            LOG.info("Starting cold instance");
            try {
                this.restoreIndex();
            }
            finally {
                this.moveOldIndexSnapshots();
            }
        } else if (mode == RecoveryMode.SECONDARY) {
            LOG.info("Starting secondary instance");
        }
        if (mode != RecoveryMode.PRIMARY) {
            EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
            eventPublisher.publish((Object)new DisasterRecoveryEvent(mode));
        }
    }

    public void earlyStart() {
        RecoveryMode mode = this.getRecoveryMode();
        if (mode == RecoveryMode.COLD) {
            LOG.info("Cold instance early start");
            this.clearClusterLocks();
        }
    }

    private void restoreIndex() {
        File sourceDir = this.getSnapshotImportDirectory();
        File[] files = sourceDir.listFiles((FilenameFilter)IndexUtils.INDEX_SNAPSHOT_FILTER);
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
        for (File file : files) {
            LOG.info("Recovering snapshot file '" + file.getPath() + "'");
            IndexRecoveryManager recoveryManager = (IndexRecoveryManager)ComponentAccessor.getComponent(IndexRecoveryManager.class);
            try {
                recoveryManager.recoverIndexFromBackup(file, TaskProgressSink.NULL_SINK);
                return;
            }
            catch (IndexException indexException) {
                LOG.error("Could not recover from file '" + file.getPath() + "'", (Throwable)indexException);
            }
        }
        LOG.error("No valid index backup found in '" + sourceDir + "'");
    }

    private void moveOldIndexSnapshots() {
        try {
            FileUtils.moveDirectoryToDirectory((File)this.getSnapshotImportDirectory(), (File)this.getSnapshotArchiveDirectory(), (boolean)true);
        }
        catch (IOException ex) {
            LOG.error("Could not archive snapshot directory", (Throwable)ex);
        }
    }

    private File getSnapshotImportDirectory() {
        File snapshotImportDir = new File(((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getImportDirectory(), "indexsnapshots");
        snapshotImportDir.mkdirs();
        return snapshotImportDir;
    }

    private File getSnapshotArchiveDirectory() {
        return new File(((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getHome(), "indexarchive");
    }

    private void clearClusterLocks() {
        ClusterLockCleanupDao clusterLockDao = (ClusterLockCleanupDao)ComponentAccessor.getComponent(ClusterLockCleanupDao.class);
        clusterLockDao.releaseAllClusterLocks();
    }

    public static enum RecoveryMode {
        PRIMARY,
        SECONDARY,
        COLD;

    }
}

