/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.ha.FailedReplicationOperation;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedReplicationOperationService {
    private static final Logger log = LoggerFactory.getLogger(FailedReplicationOperationService.class);
    private final int maxRetries;

    public FailedReplicationOperationService(ApplicationProperties applicationProperties) {
        String maxRetriesString = applicationProperties.getDefaultBackedString("jira.index.replication.maxretries");
        this.maxRetries = maxRetriesString != null ? Integer.valueOf(maxRetriesString) : 4;
    }

    FailedReplicationOperationContext getContext() {
        return new FailedReplicationOperationContext();
    }

    class FailedReplicationOperationContext {
        private final Set<FailedReplicationOperation> failedReplicationOperations = new HashSet<FailedReplicationOperation>();

        private FailedReplicationOperationContext() {
        }

        void addOperation(Set<ReplicatedIndexOperation> indexOperations) {
            FailedReplicationOperation operation = new FailedReplicationOperation(indexOperations, FailedReplicationOperationService.this.maxRetries);
            this.addOperation(operation);
        }

        synchronized void addOperation(FailedReplicationOperation indexOperations) {
            this.failedReplicationOperations.remove(indexOperations);
            indexOperations.addFailure();
            if (indexOperations.exceedsMaxRetries()) {
                if (FailedReplicationOperationService.this.maxRetries > 0) {
                    log.error("Reached threshold of maximum retries for replication operation {}", (Object)indexOperations);
                }
                return;
            }
            this.failedReplicationOperations.add(indexOperations);
        }

        synchronized Collection<FailedReplicationOperation> getOperationsToRetry() {
            ArrayList<FailedReplicationOperation> operations = new ArrayList<FailedReplicationOperation>();
            Iterator<FailedReplicationOperation> iterator = this.failedReplicationOperations.iterator();
            while (iterator.hasNext()) {
                FailedReplicationOperation failedOperation = iterator.next();
                if (!failedOperation.shouldRetryNow()) continue;
                iterator.remove();
                operations.add(failedOperation);
            }
            return operations;
        }
    }
}

