/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public interface IndexSnapshotOperatorStats
extends ManagedStats {
    public void totalNumberOfCreationAttempts(int var1);

    public void totalNumberOfSuccessfulAttempts();

    public void totalNumberOfErrorAttempts();

    public void totalNumberOfBlockedAttempts();

    public void totalNumberOfPollingAttempts(int var1);

    public void totalWaitingTimeInSeconds(long var1);

    public static class Data
    implements IndexSnapshotOperatorStats {
        private static final String SYSTEM_PROPERTY_MAX_THREAD_STATS_STORED = "com.atlassian.jira.index.queueing.stats.max.threads";
        private static final long MAX_THREAD_STATS_STORED = JiraSystemProperties.getInstance().getLong("com.atlassian.jira.index.queueing.stats.max.threads", Long.valueOf(1000L));
        final MutableLongStats numberOfCreationAttempts = new MutableLongStats(new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L});
        final AtomicInteger numberOfSuccessfulAttempts = new AtomicInteger(0);
        final AtomicInteger numberOfErrorAttempts = new AtomicInteger(0);
        final AtomicInteger numberOfBlockedAttempts = new AtomicInteger(0);
        final AtomicInteger numberOfPollingAttempts = new AtomicInteger(0);
        final MutableLongStats waitingTimeInSeconds = new MutableLongStats(new long[]{TimeUnit.MINUTES.toSeconds(1L), TimeUnit.MINUTES.toSeconds(2L), TimeUnit.MINUTES.toSeconds(5L), TimeUnit.MINUTES.toSeconds(10L), TimeUnit.MINUTES.toSeconds(30L), TimeUnit.HOURS.toSeconds(1L), TimeUnit.HOURS.toSeconds(2L)});
        final LoadingCache<String, AtomicInteger> numberOfCreationAttemptsByThread = CacheBuilder.newBuilder().maximumSize(MAX_THREAD_STATS_STORED).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) {
                return new AtomicInteger(0);
            }
        });
        final LoadingCache<String, AtomicInteger> numberOfPollingAttemptsByThread = CacheBuilder.newBuilder().maximumSize(MAX_THREAD_STATS_STORED).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) {
                return new AtomicInteger(0);
            }
        });

        @Override
        public void totalNumberOfCreationAttempts(int creationAttempts) {
            this.numberOfCreationAttempts.accept((long)creationAttempts);
            ((AtomicInteger)this.numberOfCreationAttemptsByThread.getUnchecked((Object)Thread.currentThread().getName())).addAndGet(creationAttempts);
        }

        @Override
        public void totalNumberOfSuccessfulAttempts() {
            this.numberOfSuccessfulAttempts.incrementAndGet();
        }

        @Override
        public void totalNumberOfErrorAttempts() {
            this.numberOfErrorAttempts.incrementAndGet();
        }

        @Override
        public void totalNumberOfBlockedAttempts() {
            this.numberOfBlockedAttempts.incrementAndGet();
        }

        @Override
        public void totalNumberOfPollingAttempts(int pollingAttempts) {
            this.numberOfPollingAttempts.addAndGet(pollingAttempts);
            ((AtomicInteger)this.numberOfPollingAttemptsByThread.getUnchecked((Object)Thread.currentThread().getName())).addAndGet(pollingAttempts);
        }

        @Override
        public void totalWaitingTimeInSeconds(long waitingTimeInSeconds) {
            this.waitingTimeInSeconds.accept(waitingTimeInSeconds);
        }

        public String getStatsName() {
            return "IndexSnapshotOperatorStats";
        }
    }
}

