/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.entity.AbstractEntityFactory;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.model.querydsl.ReplicatedIndexOperationDTO;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.util.lang.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedIndexOperationFactory
extends AbstractEntityFactory<ReplicatedIndexOperation> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedIndexOperationFactory.class);

    @Override
    public Map<String, Object> fieldMapFrom(@Nonnull ReplicatedIndexOperation value) {
        Pair<String, String> serializedAffectedIdToVersion = ReplicatedIndexOperationFactory.serializeMap(value.getAffectedIdToVersion());
        return new FieldMap("id", (Object)value.getId()).add("nodeId", (Object)value.getNodeId()).add("indexTime", (Object)value.getIndexTime()).add("affectedIndex", (Object)value.getAffectedIndex().toString()).add("entityType", (Object)value.getEntityType().toString()).add("operation", (Object)value.getOperation().toString()).add("affectedIds", serializedAffectedIdToVersion.first()).add("versions", serializedAffectedIdToVersion.second()).add("filename", (Object)value.getBackupFilename());
    }

    @Override
    public String getEntityName() {
        return "ReplicatedIndexOperation";
    }

    @Override
    public ReplicatedIndexOperation build(@Nonnull GenericValue gv) {
        return new ReplicatedIndexOperation(gv.getLong("id"), gv.getString("nodeId"), gv.getTimestamp("indexTime"), AffectedIndex.valueOf((String)gv.getString("affectedIndex")), SharedEntityType.valueOf((String)gv.getString("entityType")), ReplicatedIndexOperation.Operation.valueOf(gv.getString("operation")), ReplicatedIndexOperationFactory.deserializeAffectedIdToVersion(gv.getString("affectedIds"), gv.getString("versions")), gv.getString("filename"));
    }

    public ReplicatedIndexOperation build(ReplicatedIndexOperationDTO dto) {
        return new ReplicatedIndexOperation(dto.getId(), dto.getNodeId(), dto.getIndexTime(), AffectedIndex.valueOf((String)dto.getAffectedIndex()), SharedEntityType.valueOf((String)dto.getEntityType()), ReplicatedIndexOperation.Operation.valueOf(dto.getOperation()), ReplicatedIndexOperationFactory.deserializeAffectedIdToVersion(dto.getAffectedIds(), dto.getVersions()), dto.getFilename());
    }

    static Pair<String, String> serializeMap(Map<Long, Long> map) {
        ArrayList<Long> keys = new ArrayList<Long>(map.size());
        ArrayList<Long> values = new ArrayList<Long>(map.size());
        map.forEach((key, value) -> {
            keys.add((Long)key);
            values.add((Long)value);
        });
        return Pair.of((Object)ReplicatedIndexOperationFactory.serializeCollection(keys), (Object)ReplicatedIndexOperationFactory.serializeCollection(values));
    }

    @VisibleForTesting
    static Map<Long, Long> deserializeAffectedIdToVersion(String affectedIdsString, String versionsString) {
        List<Long> affectedIds = ReplicatedIndexOperationFactory.deserializeList(affectedIdsString);
        List<Long> versions = ReplicatedIndexOperationFactory.deserializeList(versionsString);
        LinkedHashMap<Long, Long> affectedIdToVersionMap = new LinkedHashMap<Long, Long>();
        for (int i = 0; i < affectedIds.size(); ++i) {
            affectedIdToVersionMap.put(affectedIds.get(i), versions.size() == affectedIds.size() ? versions.get(i) : EntityDocumentFactory.ENTITY_VERSION_ZERO);
        }
        if (!versions.isEmpty() && versions.size() != affectedIds.size()) {
            LOG.error("Skipping the versions, because it has {} value(s) while the affectedIds has {} value(s). affectedIds: {}, versions: {}", new Object[]{versions.size(), affectedIds.size(), affectedIdsString, versionsString});
        }
        return affectedIdToVersionMap;
    }

    static String serializeCollection(Collection<Long> values) {
        return StringUtils.join(values, (String)",");
    }

    private static List<Long> deserializeList(String values) {
        if (StringUtils.isBlank((CharSequence)values)) {
            return Collections.emptyList();
        }
        return Arrays.stream(values.split(",")).map(Long::parseLong).collect(Collectors.toList());
    }
}

