/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.index.ha.IndexRecoveryResult;
import com.atlassian.jira.index.ha.IndexRepairStats;
import com.atlassian.jira.index.ha.MutableIndexRepairStats;
import com.google.gson.Gson;
import org.apache.log4j.Logger;

class TotalAndSnapshotIndexRepairStats
implements IndexRepairStats {
    private static final Logger log = Logger.getLogger(TotalAndSnapshotIndexRepairStats.class);
    private MutableIndexRepairStats snapshotIndexRepairStats = new MutableIndexRepairStats();
    private MutableIndexRepairStats totalIndexRepairStats = new MutableIndexRepairStats();

    TotalAndSnapshotIndexRepairStats() {
    }

    @Override
    public void onIndexRecovery(IndexRecoveryResult indexRecoveryResult, long repairTime) {
        this.snapshotIndexRepairStats.onIndexRecovery(indexRecoveryResult, repairTime);
        this.totalIndexRepairStats.onIndexRecovery(indexRecoveryResult, repairTime);
    }

    @Override
    public void onError() {
        this.snapshotIndexRepairStats.onError();
        this.totalIndexRepairStats.onError();
    }

    synchronized void onPeriodicStats() {
        MutableIndexRepairStats.Result totalResult = this.totalIndexRepairStats.get();
        MutableIndexRepairStats.Result snapshotResult = this.snapshotIndexRepairStats.get();
        this.snapshotIndexRepairStats.reset();
        Gson gson = new Gson();
        String totalJson = gson.toJson((Object)totalResult);
        String snapshotJson = gson.toJson((Object)snapshotResult);
        log.info((Object)("[JIRA-STATS] [INDEX-FIXER] index repair total stats: " + totalJson));
        log.info((Object)("[JIRA-STATS] [INDEX-FIXER] index repair snapshot stats: " + snapshotJson));
    }
}

