/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.index.ha.DefaultNodeReindexService;
import com.atlassian.jira.index.ha.FailedReplicationOperationService;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.NodeIndexCounterStore;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.ReplicationStats;
import com.atlassian.jira.index.ha.SharedEntityResolver;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.InternalIndexingService;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZDUAwareNodeReindexService
extends DefaultNodeReindexService {
    private static final Logger log = LoggerFactory.getLogger(ZDUAwareNodeReindexService.class);
    private final FeatureManager featureManager;

    public ZDUAwareNodeReindexService(ClusterManager clusterManager, NodeIndexCounterStore nodeIndexCounterStore, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager indexManager, SharedEntityIndexer sharedEntityIndexer, ProjectManager projectManager, ProjectReindexService projectReindexService, IssueManager issueManager, CommentManager commentManager, WorklogManager worklogManager, SharedEntityResolver sharedEntityResolver, IndexCopyService indexCopyService, IssueIndexingService indexingService, InternalIndexingService internalIndexingService, IndexLifecycleManager indexLifecycleManager, FailedReplicationOperationService failedReplicationOperationService, EventPublisher eventPublisher, FeatureManager featureManager) {
        super(clusterManager, nodeIndexCounterStore, ofBizNodeIndexOperationStore, indexManager, sharedEntityIndexer, projectManager, projectReindexService, issueManager, commentManager, worklogManager, sharedEntityResolver, indexCopyService, indexingService, internalIndexingService, indexLifecycleManager, failedReplicationOperationService, eventPublisher);
        this.featureManager = featureManager;
    }

    private boolean isEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.USE_VERSION_BASED_NODE_REINDEX_SERVICE);
    }

    @Override
    void processIssueIndexingOperations(Set<ReplicatedIndexOperation> issueIndexingOps) throws IndexException {
        if (this.isEnabled()) {
            log.trace("[INDEX-REPLAY] [POST-ZDU] Processing {} issue indexing operations.", (Object)issueIndexingOps.size());
            super.processIssueIndexingOperations(issueIndexingOps);
        } else {
            log.debug("[INDEX-REPLAY] [ZDU] Processing {} issue indexing operations.", (Object)issueIndexingOps.size());
            this.updateIssueIndex(issueIndexingOps);
        }
    }

    @Override
    void processCommentIndexingOperations(Set<ReplicatedIndexOperation> commentIndexingOps) throws IndexException {
        if (this.isEnabled()) {
            log.trace("[INDEX-REPLAY] [POST-ZDU] Processing {} comments indexing operations.", (Object)commentIndexingOps.size());
            super.processCommentIndexingOperations(commentIndexingOps);
        } else {
            log.debug("[INDEX-REPLAY] [ZDU] Processing {} comments indexing operations.", (Object)commentIndexingOps.size());
            this.updateCommentsIndex(commentIndexingOps);
        }
    }

    @Override
    void processWorklogIndexingOperations(Set<ReplicatedIndexOperation> worklogIndexingOps) throws IndexException {
        if (this.isEnabled()) {
            log.debug("[INDEX-REPLAY] [POST-ZDU] Processing {} worklogs indexing operations.", (Object)worklogIndexingOps.size());
            super.processWorklogIndexingOperations(worklogIndexingOps);
        } else {
            log.debug("[INDEX-REPLAY] [ZDU] Processing {} worklogs indexing operations.", (Object)worklogIndexingOps.size());
            this.updateWorklogsIndex(worklogIndexingOps);
        }
    }

    private void updateCommentsIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet commentsToIndex = Sets.newHashSet();
        HashSet commentsToDelete = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            if (ReplicatedIndexOperation.Operation.DELETE.equals((Object)operation.getOperation())) {
                commentsToDelete.addAll(operation.getAffectedIds().stream().map(id -> () -> id).collect(Collectors.toSet()));
                continue;
            }
            for (Long id2 : operation.getAffectedIds()) {
                Comment comment = this.commentManager.getCommentById(id2);
                if (comment == null) continue;
                commentsToIndex.add(comment);
            }
        }
        if (!commentsToIndex.isEmpty()) {
            long startTime = System.currentTimeMillis();
            this.indexingService.reIndexComments((Collection)commentsToIndex, Contexts.nullContext(), false);
            long endTime = System.currentTimeMillis();
            indexOps.forEach(op -> this.recordStats(ReplicationStats.Index.COMMENT, endTime, startTime, op.getIndexTime().getTime()));
        }
        if (!commentsToDelete.isEmpty()) {
            this.indexingService.deIndexComments((Set)commentsToDelete, false);
        }
    }

    private void updateWorklogsIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet worklogsToIndex = Sets.newHashSet();
        HashSet worklogsToDelete = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            if (ReplicatedIndexOperation.Operation.DELETE.equals((Object)operation.getOperation())) {
                worklogsToDelete.addAll(operation.getAffectedIds().stream().map(id -> () -> id).collect(Collectors.toSet()));
                continue;
            }
            for (Long id2 : operation.getAffectedIds()) {
                Worklog worklog = this.worklogManager.getById(id2);
                if (worklog == null) continue;
                worklogsToIndex.add(worklog);
            }
        }
        if (!worklogsToIndex.isEmpty()) {
            long startTime = System.currentTimeMillis();
            this.indexingService.reIndexWorklogs((Collection)worklogsToIndex, Contexts.nullContext(), false);
            long endTime = System.currentTimeMillis();
            indexOps.forEach(op -> this.recordStats(ReplicationStats.Index.WORKLOG, endTime, startTime, op.getIndexTime().getTime()));
        }
        if (!worklogsToDelete.isEmpty()) {
            this.indexingService.deIndexWorklogs((Set)worklogsToDelete, false);
        }
    }

    private void updateIssueIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet projectsToUpdate = Sets.newHashSet();
        HashSet projectToDeIndex = Sets.newHashSet();
        HashSet issuesToUpdate = Sets.newHashSet();
        HashSet issuesAndRelatedIndexesToUpdate = Sets.newHashSet();
        HashSet<Long> issueIdsToDelete = new HashSet<Long>();
        block14: for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    issuesToUpdate.addAll(this.issueManager.getIssueObjects(operation.getAffectedIds()));
                    break;
                }
                case UPDATE_WITH_RELATED: {
                    issuesAndRelatedIndexesToUpdate.addAll(this.issueManager.getIssueObjects(operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    issueIdsToDelete.addAll(operation.getAffectedIds());
                    break;
                }
                case PROJECT_REINDEX: {
                    Project project;
                    for (long id : operation.getAffectedIds()) {
                        project = this.projectManager.getProjectObj(Long.valueOf(id));
                        if (project == null) continue;
                        projectsToUpdate.add(project);
                    }
                    continue block14;
                }
                case PROJECT_DEINDEX: {
                    Project project;
                    for (long id : operation.getAffectedIds()) {
                        project = this.projectManager.getProjectObj(Long.valueOf(id));
                        if (project == null) continue;
                        projectToDeIndex.add(project);
                    }
                    break;
                }
            }
        }
        issuesToUpdate.removeAll(issuesAndRelatedIndexesToUpdate);
        long issuesToUpdateStartTimestamp = System.currentTimeMillis();
        if (!issuesToUpdate.isEmpty()) {
            this.indexingService.reIndexIssueObjects((Collection)issuesToUpdate, IssueIndexingParams.builder().withChangeHistory().build(), false);
        }
        long issuesToUpdateStopTimestamp = System.currentTimeMillis();
        long issuesAndRelatedIndexesToUpdateStartTimestamp = System.currentTimeMillis();
        if (!issuesAndRelatedIndexesToUpdate.isEmpty()) {
            this.internalIndexingService.unconditionallyReindexIssuesAndRelatedEntitiesLocally(issuesAndRelatedIndexesToUpdate);
            this.indexingService.reIndexIssueObjects((Collection)issuesAndRelatedIndexesToUpdate, IssueIndexingParams.INDEX_ALL, false);
        }
        long issuesAndRelatedIndexesToUpdateStopTimestamp = System.currentTimeMillis();
        long issuesToDeleteStartTimestamp = System.currentTimeMillis();
        if (!issueIdsToDelete.isEmpty()) {
            Set withIdsToDelete = issueIdsToDelete.stream().map(l -> () -> l).collect(Collectors.toSet());
            this.indexingService.deIndexIssueObjectsById(withIdsToDelete, false);
        }
        long issuesToDeleteStopTimestamp = System.currentTimeMillis();
        long projectsToUpdateStartTimestamp = System.currentTimeMillis();
        projectsToUpdate.forEach(this::reindexProject);
        long projectsToUpdateStopTimestamp = System.currentTimeMillis();
        long projectsToDeIndexStopTimestamp = System.currentTimeMillis();
        projectToDeIndex.forEach(this::deindexProject);
        long projectsToDeIndexStartTimestamp = System.currentTimeMillis();
        block17: for (ReplicatedIndexOperation operation : indexOps) {
            long end;
            long start;
            switch (operation.getOperation()) {
                case UPDATE: 
                case CREATE: {
                    start = issuesToUpdateStartTimestamp;
                    end = issuesToUpdateStopTimestamp;
                    break;
                }
                case UPDATE_WITH_RELATED: {
                    start = issuesAndRelatedIndexesToUpdateStartTimestamp;
                    end = issuesAndRelatedIndexesToUpdateStopTimestamp;
                    break;
                }
                case DELETE: {
                    start = issuesToDeleteStartTimestamp;
                    end = issuesToDeleteStopTimestamp;
                    break;
                }
                case PROJECT_REINDEX: {
                    start = projectsToUpdateStartTimestamp;
                    end = projectsToUpdateStopTimestamp;
                    break;
                }
                case PROJECT_DEINDEX: {
                    start = projectsToDeIndexStartTimestamp;
                    end = projectsToDeIndexStopTimestamp;
                    break;
                }
                default: {
                    continue block17;
                }
            }
            long replicationLatency = end - operation.getIndexTime().getTime();
            long localOperationTime = end - start;
            IndexingTimers.REPLICATION_LATENCY.update(replicationLatency, TimeUnit.MILLISECONDS);
            this.replicationStats.addDataPoint(ReplicationStats.Index.ISSUE, replicationLatency, localOperationTime);
        }
    }
}

