/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.property.AliasClauseInformation;
import com.atlassian.jira.index.property.IssuePropertyClauseValueGenerator;
import com.atlassian.jira.index.property.IssuePropertyClauseValueGeneratorFactory;
import com.atlassian.jira.index.property.IssuePropertyJql;
import com.atlassian.jira.index.property.JqlAlias;
import com.atlassian.jira.index.property.JqlAliasFactory;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.permission.IssuePropertyClausePermissionChecker;
import com.atlassian.jira.jql.query.AliasedIssuePropertyClauseQueryFactory;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class DefaultJqlAliasFactory
implements JqlAliasFactory {
    private final JiraAuthenticationContext authenticationContext;
    private final SimpleClauseContextFactory clauseContextFactory;
    private final DoubleConverter doubleConverter;
    private final JqlDateSupport jqlDateSupport;
    private final JqlOperandResolver operandResolver;
    private final PluginAccessor pluginAccessor;
    private final IssuePropertyClauseValueGeneratorFactory valuesGeneratorFactory;

    public DefaultJqlAliasFactory(SimpleClauseContextFactory clauseContextFactory, DoubleConverter doubleConverter, JqlDateSupport jqlDateSupport, JqlOperandResolver operandResolver, JiraAuthenticationContext authenticationContext, IssuePropertyClauseValueGeneratorFactory valuesGeneratorFactory, PluginAccessor pluginAccessor) {
        this.clauseContextFactory = clauseContextFactory;
        this.doubleConverter = doubleConverter;
        this.jqlDateSupport = jqlDateSupport;
        this.operandResolver = operandResolver;
        this.authenticationContext = authenticationContext;
        this.valuesGeneratorFactory = valuesGeneratorFactory;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public JqlAlias createAlias(@Nonnull String pluginKey, @Nonnull String propertyKey, @Nonnull IndexDocumentConfiguration.ExtractConfiguration extractConfiguration, @Nonnull String alias) {
        Property property = new Property((List)ImmutableList.of((Object)propertyKey), (List)ImmutableList.of((Object)extractConfiguration.getPath()), extractConfiguration.getType());
        IssuePropertyJql issuePropertyJql = IssuePropertyJql.getIssuePropertyJql(property);
        AliasClauseInformation clauseInformation = new AliasClauseInformation(extractConfiguration.getType(), alias, AliasedIssuePropertyClauseQueryFactory.getLuceneFieldName(property), this.getClauseNames(issuePropertyJql, alias), issuePropertyJql, this.getConflictingPluginName(pluginKey, extractConfiguration), property);
        AliasedIssuePropertyClauseQueryFactory queryFactory = new AliasedIssuePropertyClauseQueryFactory(this.doubleConverter, this.jqlDateSupport, this.operandResolver, this.authenticationContext, property, extractConfiguration.getType(), extractConfiguration.getType().getOperators());
        AliasedPropertyClauseValidator validator = new AliasedPropertyClauseValidator(extractConfiguration);
        DefaultClausePermissionHandler permissionHandler = new DefaultClausePermissionHandler(new IssuePropertyClausePermissionChecker());
        ClauseHandler clauseHandler = this.getClauseHandler(clauseInformation, queryFactory, validator, permissionHandler, extractConfiguration, property);
        return new JqlAlias(clauseHandler);
    }

    private String getConflictingPluginName(String pluginKey, IndexDocumentConfiguration.ExtractConfiguration extractConfiguration) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (extractConfiguration.getPluginName().isPresent()) {
            return (String)extractConfiguration.getPluginName().get();
        }
        if (plugin != null) {
            return plugin.getName();
        }
        return pluginKey;
    }

    private ClauseHandler getClauseHandler(AliasClauseInformation clauseInformation, AliasedIssuePropertyClauseQueryFactory queryFactory, AliasedPropertyClauseValidator validator, DefaultClausePermissionHandler permissionHandler, IndexDocumentConfiguration.ExtractConfiguration extractConfiguration, Property property) {
        if (extractConfiguration.getType().equals((Object)IndexDocumentConfiguration.Type.STRING)) {
            IssuePropertyClauseValueGenerator valueGenerator = this.valuesGeneratorFactory.create(property);
            return new DefaultValuesGeneratingClauseHandler(clauseInformation, queryFactory, validator, permissionHandler, this.clauseContextFactory, valueGenerator);
        }
        return new DefaultClauseHandler(clauseInformation, queryFactory, validator, permissionHandler, this.clauseContextFactory);
    }

    private ClauseNames getClauseNames(IssuePropertyJql issuePropertyJql, String alias) {
        return new ClauseNames(issuePropertyJql.getCanonicalJql(), new String[]{alias});
    }

    private static class AliasedPropertyClauseValidator
    implements ClauseValidator {
        private final SupportedOperatorsValidator supportedOperatorsValidator;

        public AliasedPropertyClauseValidator(IndexDocumentConfiguration.ExtractConfiguration extractConfiguration) {
            this.supportedOperatorsValidator = new SupportedOperatorsValidator(new Collection[]{extractConfiguration.getType().getOperators()});
        }

        @Nonnull
        public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
            return this.supportedOperatorsValidator.validate(searcher, terminalClause);
        }
    }
}

