/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.IndexDocumentConfigurationFactory;
import com.atlassian.jira.index.property.EntityPropertyIndexDocument;
import com.atlassian.jira.index.property.EntityPropertyIndexDocumentFactory;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizPluginIndexConfigurationManager
implements PluginIndexConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(OfBizPluginIndexConfigurationManager.class);
    private final EntityEngine entityEngine;
    private final IndexDocumentConfigurationFactory indexDocumentConfigurationFactory;
    private final ReindexMessageManager reindexMessageManager;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;

    public OfBizPluginIndexConfigurationManager(EntityEngine entityEngine, IndexDocumentConfigurationFactory indexDocumentConfigurationFactory, ReindexMessageManager reindexMessageManager, JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.entityEngine = entityEngine;
        this.indexDocumentConfigurationFactory = indexDocumentConfigurationFactory;
        this.reindexMessageManager = reindexMessageManager;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    static void restrictLength(String field, String value, int maximumLength) {
        if (value.length() > maximumLength) {
            throw new IllegalArgumentException("Value of " + field + " is too long. Maximum length is " + maximumLength);
        }
    }

    @Override
    public Iterable<PluginIndexConfiguration> getDocumentsForEntity(final @Nonnull String entityName) {
        List indexDocuments = Select.from(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).whereEqual("entityKey", entityName).runWith(this.entityEngine).asList();
        return Iterables.filter((Iterable)Iterables.transform(indexDocuments, (Function)new Function<EntityPropertyIndexDocument, PluginIndexConfiguration>(){

            @Override
            public PluginIndexConfiguration apply(EntityPropertyIndexDocument indexDocument) {
                try {
                    return new PluginIndexConfigurationImpl(indexDocument.getPluginKey(), indexDocument.getModuleKey(), OfBizPluginIndexConfigurationManager.this.indexDocumentConfigurationFactory.fromXML(indexDocument.getDocument()), indexDocument.getUpdated());
                }
                catch (IndexDocumentConfigurationFactory.IndexDocumentConfigurationParseException e) {
                    log.error("The configuration of index document for entity " + entityName + " is invalid id=" + indexDocument.getId(), (Throwable)e);
                    return null;
                }
            }
        }), Objects::nonNull);
    }

    @Override
    public void put(final @Nonnull String pluginKey, final @Nonnull String moduleKey, final @Nonnull IndexDocumentConfiguration document) {
        Assertions.notNull((String)"pluginKey", (Object)pluginKey);
        OfBizPluginIndexConfigurationManager.restrictLength("pluginKey", pluginKey, 255);
        Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        OfBizPluginIndexConfigurationManager.restrictLength("moduleKey", moduleKey, 255);
        Assertions.notNull((String)"document", (Object)document);
        final String documentValue = this.indexDocumentConfigurationFactory.toXML(document);
        Assertions.notBlank((String)"documentValue", (String)documentValue);
        OfBizPluginIndexConfigurationManager.restrictLength("documentValue", documentValue, 32768);
        final String entityKey = document.getEntityKey();
        Assertions.notNull((String)"entityKey", (Object)entityKey);
        OfBizPluginIndexConfigurationManager.restrictLength("entityKey", entityKey, 255);
        Option<EntityPropertyIndexDocument> entityPropertyIndexDocument = this.getDocumentForPluginAndModule(pluginKey, moduleKey);
        final Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        entityPropertyIndexDocument.fold((Supplier)new Supplier<Void>(){

            @Override
            public Void get() {
                final EntityPropertyIndexDocumentFactory.EntityPropertyIndexDocumentImpl indexDocument = new EntityPropertyIndexDocumentFactory.EntityPropertyIndexDocumentImpl(null, pluginKey, moduleKey, entityKey, documentValue, timestamp);
                OfBizPluginIndexConfigurationManager.this.doDbOperation(pluginKey, moduleKey, document, new Runnable(){

                    @Override
                    public void run() {
                        OfBizPluginIndexConfigurationManager.this.entityEngine.createValue(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT, indexDocument);
                        OfBizPluginIndexConfigurationManager.this.checkReindexRequired(document);
                    }
                });
                return null;
            }
        }, (Function)new Function<EntityPropertyIndexDocument, Void>(){

            @Override
            public Void apply(final EntityPropertyIndexDocument existing) {
                if (!OfBizPluginIndexConfigurationManager.this.configurationsEquals(document, existing.getDocument())) {
                    OfBizPluginIndexConfigurationManager.this.doDbOperation(pluginKey, moduleKey, document, new Runnable(){

                        @Override
                        public void run() {
                            Update.into(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).set("document", documentValue).set("updated", timestamp).set("entityKey", entityKey).whereEqual("id", existing.getId()).execute(OfBizPluginIndexConfigurationManager.this.entityEngine);
                            OfBizPluginIndexConfigurationManager.this.checkReindexRequired(document);
                        }
                    });
                }
                return null;
            }
        });
    }

    private void doDbOperation(String pluginKey, String moduleKey, IndexDocumentConfiguration document, Runnable command) {
        try {
            command.run();
        }
        catch (DataAccessException e) {
            log.debug("Cannot add IndexDocumentConfiguration for pluginKey= " + pluginKey + " moduleKey = " + moduleKey + " document = " + document.toString(), (Throwable)e);
        }
    }

    private void checkReindexRequired(IndexDocumentConfiguration document) {
        Iterable configurationElements = document.getConfigurationElements();
        if (Iterables.any((Iterable)configurationElements, (Predicate)new Predicate<IndexDocumentConfiguration.ConfigurationElement>(){

            @Override
            public boolean test(IndexDocumentConfiguration.ConfigurationElement input) {
                return OfBizPluginIndexConfigurationManager.this.jsonEntityPropertyManager.countByEntityNameAndPropertyKey(input.getEntityKey(), input.getPropertyKey()) > 0L;
            }
        })) {
            this.reindexMessageManager.pushMessage((ApplicationUser)null, "jira.plugin.index.configuration");
        }
    }

    private boolean configurationsEquals(IndexDocumentConfiguration newConfiguration, String existingConfigurationStr) {
        try {
            IndexDocumentConfiguration existingConfiguration = this.indexDocumentConfigurationFactory.fromXML(existingConfigurationStr);
            return existingConfiguration.equals((Object)newConfiguration);
        }
        catch (IndexDocumentConfigurationFactory.IndexDocumentConfigurationParseException e) {
            return false;
        }
    }

    @Override
    public void remove(@Nonnull String pluginKey) {
        Delete.from(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).whereEqual("pluginKey", pluginKey).execute(this.entityEngine);
    }

    private Option<EntityPropertyIndexDocument> getDocumentForPluginAndModule(String pluginKey, String moduleKey) {
        EntityPropertyIndexDocument entityPropertyIndexDocument = (EntityPropertyIndexDocument)Select.from(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).whereEqual("pluginKey", pluginKey).whereEqual("moduleKey", moduleKey).runWith(this.entityEngine).singleValue();
        return Option.option((Object)entityPropertyIndexDocument);
    }

    public static class PluginIndexConfigurationImpl
    implements PluginIndexConfiguration {
        private final String pluginKey;
        private final String moduleKey;
        private final IndexDocumentConfiguration indexDocumentConfiguration;
        private final Timestamp lastUpdated;

        @VisibleForTesting
        public PluginIndexConfigurationImpl(String pluginKey, String moduleKey, IndexDocumentConfiguration indexDocumentConfiguration, Timestamp lastUpdated) {
            this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey);
            this.moduleKey = (String)Preconditions.checkNotNull((Object)moduleKey);
            this.indexDocumentConfiguration = (IndexDocumentConfiguration)Preconditions.checkNotNull((Object)indexDocumentConfiguration);
            this.lastUpdated = (Timestamp)Preconditions.checkNotNull((Object)lastUpdated);
        }

        @Override
        public String getPluginKey() {
            return this.pluginKey;
        }

        @Override
        public String getModuleKey() {
            return this.moduleKey;
        }

        @Override
        public IndexDocumentConfiguration getIndexDocumentConfiguration() {
            return this.indexDocumentConfiguration;
        }

        @Override
        public Timestamp getLastUpdated() {
            return this.lastUpdated;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pluginKey", (Object)this.pluginKey).add("moduleKey", (Object)this.moduleKey).add("indexDocumentConfiguration", (Object)this.indexDocumentConfiguration).add("lastUpdated", (Object)this.lastUpdated).toString();
        }
    }
}

