/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.plugin.index.EntityPropertyIndexDocumentModuleDescriptor;
import com.atlassian.jira.plugin.util.PluginModuleTrackerFactory;
import com.atlassian.jira.util.Streams;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.base.Function;
import java.util.List;

@EventComponent
public class PluginIndexConfigurationInitializer {
    private final PluginModuleTracker<Void, EntityPropertyIndexDocumentModuleDescriptor> moduleTracker;

    public PluginIndexConfigurationInitializer(PluginModuleTrackerFactory pluginModuleTrackerFactory) {
        this.moduleTracker = pluginModuleTrackerFactory.create(EntityPropertyIndexDocumentModuleDescriptor.class);
    }

    public List<String> initialisePluginIndexConfiguration() {
        Iterable epIndexModules = this.moduleTracker.getModuleDescriptors();
        return (List)Streams.stream(epIndexModules).map(epIndexModule -> {
            SafePluginPointAccess.safe((java.util.function.Function)new Function<EntityPropertyIndexDocumentModuleDescriptor, Void>(){

                public Void apply(EntityPropertyIndexDocumentModuleDescriptor input) {
                    input.init();
                    return null;
                }
            }).apply(epIndexModule);
            return epIndexModule.getCompleteKey();
        }).collect(CollectorsUtil.toImmutableList());
    }

    @EventListener
    public void onComponentManagerStartedEvent(ComponentManagerStartedEvent ignore) {
        this.initialisePluginIndexConfiguration();
    }

    @EventListener
    public void onImportCompletedEventEvent(ImportCompletedEvent ignore) {
        this.initialisePluginIndexConfiguration();
    }
}

