/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.stats;

import com.atlassian.jira.index.stats.IndexSearcherStats;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;

public class IndexSearcherWithStats
extends IndexSearcher {
    private static final Ticker TICKER = Ticker.systemTicker();
    private final IndexSearcherStats stats;

    public IndexSearcherWithStats(IndexReader r, IndexSearcherStats stats) {
        super(r);
        this.stats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document doc(int docID) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Document document = super.doc(docID);
            return document;
        }
        finally {
            this.stats.onDoc(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document doc(int docID, Set<String> fieldsToLoad) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Document document = super.doc(docID, fieldsToLoad);
            return document;
        }
        finally {
            this.stats.onDoc(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doc(int docID, StoredFieldVisitor fieldVisitor) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            super.doc(docID, fieldVisitor);
        }
        finally {
            this.stats.onDoc(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Object object = super.search(query, collectorManager);
            return (T)object;
        }
        finally {
            this.stats.onSearch(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopDocs search(Query query, int n) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            TopDocs topDocs = super.search(query, n);
            return topDocs;
        }
        finally {
            this.stats.onSearch(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(Query query, Collector results) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            super.search(query, results);
        }
        finally {
            this.stats.onSearch(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopFieldDocs search(Query query, int n, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            TopFieldDocs topFieldDocs = super.search(query, n, sort, doDocScores, doMaxScore);
            return topFieldDocs;
        }
        finally {
            this.stats.onSearch(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            TopFieldDocs topFieldDocs = super.search(query, n, sort);
            return topFieldDocs;
        }
        finally {
            this.stats.onSearch(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

